/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import com.sun.jersey.core.header.ContentDisposition;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.experiment.ExperimentData;
import org.palladiosimulator.protocom.framework.java.ee.experiment.IExperiment;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;

@Path(value="/results")
public class Results {
    private static final Logger LOGGER = Logger.getRootLogger();
    @Inject
    private IStorage storage;
    @Inject
    private IExperiment experiment;

    @GET
    @Produces(value={"application/json"})
    public Response getResults() {
        LinkedList<ExperimentData> result = new LinkedList<ExperimentData>();
        try {
            for (String folder : this.storage.getFiles("results")) {
                String dataPath = "results/" + folder + "/experiment.json";
                String json = this.storage.readFileAsString(dataPath);
                result.add(JsonHelper.fromJson(json, ExperimentData.class));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"No results stored yet");
        }
        return Response.ok((Object)JsonHelper.toJson(result)).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/octet-stream"})
    public Response getResult(final @PathParam(value="id") String id) {
        ExperimentData data;
        try {
            String path = "results/" + id + "/experiment.json";
            String json = this.storage.readFileAsString(path);
            data = JsonHelper.fromJson(json, ExperimentData.class);
        }
        catch (IOException e) {
            return Response.serverError().build();
        }
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                Results.this.zipResults(id, out);
            }
        };
        ContentDisposition disposition = ContentDisposition.type((String)"attachement").fileName(String.valueOf(data.getName()) + ".zip").build();
        return Response.ok((Object)stream).header("Content-Disposition", (Object)disposition).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteResult(@PathParam(value="id") String id) {
        try {
            String root = "results/" + id;
            for (String file : this.storage.getFiles(root)) {
                this.storage.deleteFile(String.valueOf(root) + "/" + file);
            }
            this.storage.deleteFile(root);
        }
        catch (IOException e) {
            return Response.serverError().build();
        }
        if (id.equals(this.experiment.getId())) {
            this.experiment.reset();
        }
        return Response.noContent().build();
    }

    private void zipResults(String id, OutputStream out) {
        Set<String> files;
        String root = "results/" + id;
        try {
            files = this.storage.getFiles(root);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        ZipOutputStream stream = new ZipOutputStream(out);
        try {
            for (String file : files) {
                if (file.equals("experiment.json")) continue;
                ZipEntry entry = new ZipEntry(file);
                stream.putNextEntry(entry);
                stream.write(this.storage.readFile(String.valueOf(root) + "/" + file));
                stream.closeEntry();
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

