/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.storage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;

public class EcmProxy {
    private static Object invoke(Object target, String name, Object ... args) throws Exception {
        Class[] classes = new Class[args.length];
        int i = 0;
        while (i < classes.length) {
            classes[i] = args[i].getClass();
            ++i;
        }
        Method method = target.getClass().getMethod(name, classes);
        return method.invoke(target, args);
    }

    private static void createRepository(Object ecmService, String name, String key) throws Exception {
        Class<?> optionsClass = Class.forName("com.sap.ecm.api.RepositoryOptions");
        Object options = optionsClass.newInstance();
        Class<?> enumClass = Class.forName("com.sap.ecm.api.RepositoryOptions$Visibility");
        Object visibility = enumClass.getField("PROTECTED").get(null);
        EcmProxy.invoke(options, "setUniqueName", name);
        EcmProxy.invoke(options, "setRepositoryKey", key);
        EcmProxy.invoke(options, "setVisibility", visibility);
        EcmProxy.invoke(ecmService, "createRepository", options);
    }

    private static Session connect(String name, String key) throws Exception {
        Session session;
        InitialContext context = new InitialContext();
        Object ecmService = context.lookup("java:comp/env/EcmService");
        try {
            session = (Session)EcmProxy.invoke(ecmService, "connect", name, key);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CmisObjectNotFoundException) {
                EcmProxy.createRepository(ecmService, name, key);
                session = (Session)EcmProxy.invoke(ecmService, "connect", name, key);
            }
            throw e;
        }
        return session;
    }

    public static Session getSession(String name, String key) {
        try {
            return EcmProxy.connect(name, key);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

