/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.storage;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.storage.EcmProxy;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;

@Singleton
public class EcmStorage
implements IStorage {
    private static final Logger LOGGER = Logger.getRootLogger();
    private static final String NAME = "ProtoCom-Repository";
    private static final String KEY = "protocom_key";
    private static final String MIME = "application/octet-stream";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Session session = EcmProxy.getSession("ProtoCom-Repository", "protocom_key");

    private Map<String, Object> getProperties(String path, boolean folder) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String type = folder ? "cmis:folder" : "cmis:document";
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", path);
        return properties;
    }

    private ContentStream createContentStream(String file, byte[] data) {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        ObjectFactory factory = this.session.getObjectFactory();
        return factory.createContentStream(file, (long)data.length, MIME, (InputStream)stream);
    }

    private Folder getParentFolder(String path) throws IOException {
        String parent = this.getPathParent(path);
        if (parent != null) {
            try {
                return (Folder)this.session.getObjectByPath(this.checkPath(parent));
            }
            catch (CmisObjectNotFoundException e) {
                throw new IOException("Parent folder does not exist");
            }
        }
        return this.session.getRootFolder();
    }

    private String checkPath(String path) {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    private String getPathParent(String path) {
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex > 0) {
            return path.substring(0, lastIndex);
        }
        return null;
    }

    private String getPathFile(String path) {
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex > 0) {
            return path.substring(lastIndex + 1);
        }
        return path;
    }

    @Override
    public void createFolder(String path) throws IOException {
        try {
            this.getParentFolder(path).createFolder(this.getProperties(this.getPathFile(path), true));
        }
        catch (CmisNameConstraintViolationException e) {
            LOGGER.debug((Object)("Folder '" + path + "' already exists"));
        }
    }

    @Override
    public void writeFile(String path, byte[] data) throws IOException {
        String file = this.getPathFile(path);
        ContentStream content = this.createContentStream(file, data);
        Folder folder = this.getParentFolder(path);
        try {
            Document document = (Document)this.session.getObjectByPath(this.checkPath(path));
            document.setContentStream(content, true);
        }
        catch (CmisObjectNotFoundException e1) {
            try {
                folder.createDocument(this.getProperties(file, false), content, VersioningState.NONE);
            }
            catch (CmisNameConstraintViolationException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void writeFile(String path, String data) throws IOException {
        byte[] bytes = data.getBytes(UTF_8);
        this.writeFile(path, bytes);
    }

    @Override
    public byte[] readFile(String path) throws FileNotFoundException {
        Document document;
        try {
            document = (Document)this.session.getObjectByPath(this.checkPath(path));
        }
        catch (CmisObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        ContentStream content = document.getContentStream();
        byte[] data = null;
        try {
            data = IOUtils.toByteArray((InputStream)content.getStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public String readFileAsString(String path) throws FileNotFoundException {
        byte[] bytes = this.readFile(path);
        return new String(bytes, UTF_8);
    }

    @Override
    public Set<String> getFiles(String path) throws IOException {
        Folder folder;
        try {
            folder = (Folder)this.session.getObjectByPath(this.checkPath(path));
        }
        catch (CmisObjectNotFoundException e) {
            throw new IOException("Folder does not exist");
        }
        HashSet<String> files = new HashSet<String>();
        for (CmisObject object : folder.getChildren()) {
            files.add(object.getName());
        }
        return files;
    }

    @Override
    public void deleteFile(String path) {
        CmisObject object = this.session.getObjectByPath(this.checkPath(path));
        object.delete();
    }

    @Override
    public boolean isFolder(String path) {
        try {
            CmisObject object = this.session.getObjectByPath(path);
            return object instanceof Folder;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean fileExists(String path) {
        try {
            this.session.getObjectByPath(this.checkPath(path));
            return true;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }
}

