/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.usage;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.se.IStopable;
import org.palladiosimulator.protocom.framework.java.se.experiment.ExperimentManager;
import org.palladiosimulator.protocom.framework.java.se.utils.RunProperties;

public abstract class AbstractScenarioThread
extends Thread
implements IStopable {
    protected static final Logger LOGGER = Logger.getLogger(AbstractScenarioThread.class);
    private static AtomicLong measurementTotalCount = null;
    protected long maxMeasurementCount = -1L;
    ExperimentRun experimentRun = null;
    protected boolean shouldContinue = true;
    protected String scenarioName;
    private final TimeSpanSensor timeSpanSensor;

    static {
        measurementTotalCount = new AtomicLong(0L);
    }

    public AbstractScenarioThread(Experiment exp, ExperimentRun expRun, String scenarioName, RunProperties runProps) {
        this.experimentRun = expRun;
        this.scenarioName = scenarioName;
        this.timeSpanSensor = ExperimentManager.createOrReuseTimeSpanSensor(scenarioName);
        if (runProps.hasOption("m")) {
            this.maxMeasurementCount = Integer.parseInt(runProps.getOptionValue('m'));
        }
        int warmupRuns = 1000;
        if (runProps.hasOption("u")) {
            warmupRuns = Integer.parseInt(runProps.getOptionValue('u'));
        }
        LOGGER.info((Object)("Warmup - Cyles: " + warmupRuns));
        int i = 0;
        while (i < warmupRuns) {
            LOGGER.info((Object)("Warmup started, cycle: " + i));
            this.getScenarioRunner(runProps).run();
            ++i;
        }
        LOGGER.info((Object)"Warmup finished");
        measurementTotalCount = new AtomicLong(0L);
    }

    @Override
    public void run() {
        while (this.shouldContinue) {
            LOGGER.debug((Object)"Starting my scenario");
            try {
                this.runAndMeasureUsageScenarioIteration();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.shouldContinue = false;
                break;
            }
        }
    }

    protected abstract void runAndMeasureUsageScenarioIteration();

    protected void takeScenarioMeasurement(long start) {
        long now = System.nanoTime();
        double measuredTimeSpan = (double)(now - start) / Math.pow(10.0, 9.0);
        this.experimentRun.addTimeSpanMeasurement(this.timeSpanSensor, (double)now / Math.pow(10.0, 9.0), measuredTimeSpan);
        LOGGER.debug((Object)"Finished my scenario");
        long value = measurementTotalCount.incrementAndGet();
        LOGGER.debug((Object)("Execution of scenario iteration no " + value + " took: " + measuredTimeSpan + " seconds"));
        if (this.maxMeasurementCount > 0L && value >= this.maxMeasurementCount && this.shouldContinue) {
            LOGGER.info((Object)"Reached maximum measurement count");
            this.shouldContinue = false;
        }
    }

    @Override
    public void requestStop() {
        this.shouldContinue = false;
    }

    protected abstract Runnable getScenarioRunner(RunProperties var1);
}

