/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.registry;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.se.experiment.IExperimentManager;
import org.palladiosimulator.protocom.framework.java.se.registry.IRmiRegistry;

public class RmiRegistry
extends UnicastRemoteObject
implements IRmiRegistry,
Serializable {
    protected static final Logger LOGGER = Logger.getLogger(RmiRegistry.class);
    private static final long serialVersionUID = 8964579189837506625L;
    public static final String LOCALHOST = "localhost";
    private static RmiRegistry singleton;
    private static String configuredRemoteAddr;
    private static int configuredRegistryPort;
    private final List<IExperimentManager> experimentManagers = new LinkedList<IExperimentManager>();

    static {
        configuredRemoteAddr = LOCALHOST;
        configuredRegistryPort = 1099;
    }

    private RmiRegistry() throws RemoteException {
        try {
            LocateRegistry.createRegistry(configuredRegistryPort);
            LOGGER.info((Object)("Java RMI registry started at port " + configuredRegistryPort));
        }
        catch (RemoteException e) {
            LocateRegistry.getRegistry(configuredRegistryPort);
            LOGGER.info((Object)("Java RMI registry already running at port " + configuredRegistryPort));
        }
        try {
            Naming.lookup("//" + configuredRemoteAddr + ":" + configuredRegistryPort + "/" + "PCM_RMI_REGISTRY");
            LOGGER.info((Object)"RMI binding service already running");
        }
        catch (MalformedURLException e) {
        }
        catch (NotBoundException e) {
            String bindingName;
            LOGGER.info((Object)"Starting RMI binding service");
            try {
                bindingName = "//" + configuredRemoteAddr + ":" + configuredRegistryPort + "/" + "PCM_RMI_REGISTRY";
                Naming.bind(bindingName, this);
                LOGGER.info((Object)("RMI binding service bound as " + bindingName));
            }
            catch (MalformedURLException e2) {
                LOGGER.error((Object)"RMI registry failed: Malformed URL", (Throwable)e2);
            }
            catch (AlreadyBoundException e2) {
                LOGGER.error((Object)"RMI registry failed: Registry already bound on this port", (Throwable)e2);
            }
            try {
                bindingName = "//" + configuredRemoteAddr + ":" + configuredRegistryPort + "/" + "PCM_EXPERIMENT_MANAGER_REGISTRY";
                Naming.bind(bindingName, this);
                LOGGER.info((Object)("Experiment Manager service bound as " + bindingName));
            }
            catch (MalformedURLException e2) {
                LOGGER.error((Object)"Experiment Manager service failed: Malformed URL", (Throwable)e2);
            }
            catch (AlreadyBoundException e2) {
                LOGGER.error((Object)"Experiment Manager service failed: Service already bound on this port", (Throwable)e2);
            }
        }
    }

    @Override
    public void bindPort(String name, Remote portClass) throws RemoteException {
        String bindingName = "//" + RmiRegistry.getRemoteAddress() + ":" + RmiRegistry.getRegistryPort() + "/" + name;
        LOGGER.info((Object)("Binding " + name + " to RMI registry as " + bindingName));
        try {
            Naming.rebind(bindingName, portClass);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"RMI registry failed", (Throwable)e);
        }
    }

    public static void startRegistry() {
        if (singleton == null) {
            try {
                singleton = new RmiRegistry();
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"RMI registry failed", (Throwable)e);
            }
        }
    }

    public static void registerPort(String registryIP, int registryPort, Remote component, String componentName) {
        try {
            Registry reg = LocateRegistry.getRegistry(registryIP, registryPort);
            LOGGER.info((Object)("Located Java RMI Registy at " + registryIP + ":" + registryPort + ", " + reg));
            IRmiRegistry pcmRegistry = null;
            String bindingName = "PCM_RMI_REGISTRY";
            while (true) {
                try {
                    pcmRegistry = (IRmiRegistry)reg.lookup(bindingName);
                    pcmRegistry.bindPort(componentName, component);
                }
                catch (ServerException e) {
                    LOGGER.error((Object)"Server Error: Check marshalling/serialization of your model!", (Throwable)e);
                }
                catch (RemoteException e) {
                    LOGGER.info((Object)("RMI registry (" + bindingName + ") at " + registryIP + ":" + registryPort + " not found. Next attempt in 3 seconds."));
                    Thread.sleep(3000L);
                    continue;
                }
                catch (NotBoundException e) {
                    LOGGER.info((Object)("RMI binding service (" + bindingName + ") at " + registryIP + ":" + registryPort + " not found. Next attempt in 3 seconds."));
                    Thread.sleep(3000L);
                    continue;
                }
                break;
            }
            LOGGER.info((Object)(String.valueOf(componentName) + " bound in registry"));
        }
        catch (Exception e) {
            LOGGER.error((Object)(String.valueOf(componentName) + " err: " + e.getMessage()));
        }
    }

    public static String getIpFromArguments(String[] args) {
        if (args != null && args.length > 0 && args[0] != null && !args[0].equals("")) {
            return args[0];
        }
        return LOCALHOST;
    }

    public static int getPortFromArguments(String[] args) {
        if (args != null && args.length > 1 && args[1] != null && !args[1].equals("")) {
            return Integer.parseInt(args[1]);
        }
        return 1099;
    }

    public static Remote lookup(String name) {
        Remote result = null;
        LOGGER.info((Object)("RMI lookup for: " + name));
        if (RmiRegistry.getRemoteAddress() == null) {
            LOGGER.error((Object)"Remote address of RMI registry not defined.");
            return null;
        }
        String addr = "//" + RmiRegistry.getRemoteAddress() + ":" + RmiRegistry.getRegistryPort() + "/" + name;
        while (true) {
            try {
                result = Naming.lookup(addr);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Remote URI malformed. This should never happen, strange model names used? (" + addr + ")"));
            }
            catch (RemoteException e) {
                LOGGER.error((Object)("Error while waiting for system. (" + addr + ")" + e));
            }
            catch (NotBoundException e) {
                LOGGER.info((Object)("System missing: " + e.getMessage()));
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException innerE) {
                    LOGGER.error((Object)("Error while waiting for system. " + e));
                }
                continue;
            }
            break;
        }
        return result;
    }

    public static String getRemoteAddress() {
        return configuredRemoteAddr;
    }

    public static void setRemoteAddress(String configuredRemoteAddr) {
        assert (configuredRemoteAddr != null);
        RmiRegistry.configuredRemoteAddr = configuredRemoteAddr;
    }

    public static int getRegistryPort() {
        return configuredRegistryPort;
    }

    public static void setRegistryPort(int configuredRegistryPort) {
        RmiRegistry.configuredRegistryPort = configuredRegistryPort;
    }

    public static void main(String[] args) {
        RmiRegistry.startRegistry();
        LOGGER.info((Object)("RMI registry started on port " + configuredRegistryPort));
        new Thread(){

            @Override
            public void run() {
                Scanner input = new Scanner(System.in);
                if (input.hasNext()) {
                    input.nextLine();
                }
            }
        }.run();
    }

    @Override
    public void bindExperimentManager(IExperimentManager experimentManager) throws RemoteException {
        this.experimentManagers.add(experimentManager);
        LOGGER.info((Object)("Added " + experimentManager.getName() + " to associated experiment managers"));
    }

    @Override
    public List<IExperimentManager> getExperimentManagers() {
        return this.experimentManagers;
    }
}

