/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.experiment;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.management.RuntimeErrorException;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.se.experiment.IExperimentManager;
import org.palladiosimulator.protocom.framework.java.se.registry.IRmiRegistry;
import org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry;

public class ExperimentManager
extends UnicastRemoteObject
implements IExperimentManager,
Serializable {
    private static final long serialVersionUID = 4939697784092741922L;
    protected static final Logger LOGGER = Logger.getRootLogger();
    private int remoteType;
    private static ExperimentManager singleton;
    private transient IDAOFactory datasource;
    private Experiment exp;
    private String experimentName;

    protected ExperimentManager() throws RemoteException {
    }

    public static ExperimentManager getInstance() {
        return singleton;
    }

    @Override
    public String getName() throws RemoteException {
        return this.experimentName;
    }

    public static Experiment getExperiment() {
        return ExperimentManager.singleton.exp;
    }

    private void setExperiment(Experiment exp) {
        this.exp = exp;
    }

    public static ExperimentRun addExperimentRun() {
        if (ExperimentManager.singleton.exp == null) {
            LOGGER.error((Object)"Experiment not set");
            throw new RuntimeErrorException(null, "Experiment not set");
        }
        return ExperimentManager.singleton.exp.addExperimentRun(new Date().toString());
    }

    public static long takeStartTimeForInnerMeasurement() {
        return System.nanoTime();
    }

    public static void takeMeasurement(long start, ExperimentRun experimentRun, TimeSpanSensor timeSpanSensor) {
        LOGGER.info((Object)("Take measurement of " + timeSpanSensor.getSensorName()));
        long now = System.nanoTime();
        double measuredTimeSpan = (double)(now - start) / Math.pow(10.0, 9.0);
        experimentRun.addTimeSpanMeasurement(timeSpanSensor, (double)now / Math.pow(10.0, 9.0), measuredTimeSpan);
    }

    public static TimeSpanSensor createOrReuseTimeSpanSensor(String sensorName) {
        Collection existingSensors = ExperimentManager.singleton.exp.getSensors();
        for (Sensor sensor : existingSensors) {
            if (!(sensor instanceof TimeSpanSensor) || !sensor.getSensorName().equals(sensorName)) continue;
            return (TimeSpanSensor)sensor;
        }
        TimeSpanSensor tss = ExperimentManager.getExperiment().addTimeSpanSensor(sensorName);
        return tss;
    }

    public static ExperimentRun getLatestExperimentRun() {
        if (ExperimentManager.getExperiment().getExperimentRuns().isEmpty()) {
            ExperimentManager.addExperimentRun();
        }
        Collection runs = ExperimentManager.getExperiment().getExperimentRuns();
        Iterator it = runs.iterator();
        ExperimentRun experimentRun = null;
        while (it.hasNext()) {
            experimentRun = (ExperimentRun)it.next();
        }
        return experimentRun;
    }

    public static void init(String experimentName, String directory, int remoteType) {
        if (!ExperimentManager.checkDirectory(directory)) {
            String error = "Unable to find data directory. Ensure data directory exists and is writeable";
            LOGGER.error((Object)error);
            throw new RuntimeException(error);
        }
        if (singleton == null) {
            try {
                singleton = new ExperimentManager();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        ExperimentManager.singleton.experimentName = experimentName;
        ExperimentManager.singleton.remoteType = remoteType;
        ExperimentManager.singleton.datasource = new FileDAOFactory(directory);
        if (remoteType == 2) {
            IRmiRegistry registry = (IRmiRegistry)RmiRegistry.lookup("PCM_EXPERIMENT_MANAGER_REGISTRY");
            try {
                LOGGER.info((Object)("Register experiment manager for " + experimentName));
                registry.bindExperimentManager(singleton);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Failed to register experiment manager", (Throwable)e);
            }
        }
        singleton.setExperiment(ExperimentManager.singleton.datasource.createExperimentDAO().addExperiment(experimentName));
        LOGGER.info((Object)("Created data source at event time " + (double)System.nanoTime() / Math.pow(10.0, 9.0)));
    }

    private static boolean checkDirectory(String path) {
        File f = new File(path);
        if (f.isDirectory() && f.canWrite()) {
            return true;
        }
        if (!f.exists()) {
            return f.mkdir();
        }
        return false;
    }

    public void createExperimentRun() {
        ExperimentManager.addExperimentRun();
    }

    @Override
    public void writeResultsAndClose() throws RemoteException {
        LOGGER.info((Object)("Storing results for " + this.experimentName));
        LOGGER.info((Object)("Current time: " + new Date()));
        this.datasource.store();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Failed to persist measurements", (Throwable)e);
            System.exit(-1);
        }
        LOGGER.info((Object)"...Done!");
        if (this.remoteType == 1) {
            this.datasource.finalizeAndClose();
            IRmiRegistry registry = (IRmiRegistry)RmiRegistry.lookup("PCM_EXPERIMENT_MANAGER_REGISTRY");
            try {
                for (IExperimentManager manager : registry.getExperimentManagers()) {
                    LOGGER.info((Object)("Send finalizeAndClose to slave " + manager));
                    manager.writeResultsAndClose();
                }
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Failed to contact slave experiment managers", (Throwable)e);
            }
        }
    }

    @Override
    public void startNewExperimentRun() throws RemoteException {
        LOGGER.info((Object)"Received startNewExperimentRun");
        LOGGER.info((Object)("Current time: " + new Date()));
        this.createExperimentRun();
        if (this.remoteType == 1) {
            IRmiRegistry registry = (IRmiRegistry)RmiRegistry.lookup("PCM_EXPERIMENT_MANAGER_REGISTRY");
            try {
                for (IExperimentManager manager : registry.getExperimentManagers()) {
                    LOGGER.info((Object)("Send startNewExperimentRun to slave " + manager));
                    manager.startNewExperimentRun();
                }
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Failed to contact slave experiment managers", (Throwable)e);
            }
        }
    }
}

