/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.utils;

import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.se.utils.RunProperties;

public class CommandLineParser {
    protected static final Logger LOGGER = Logger.getRootLogger();

    public static RunProperties parseCommandLine(String[] arguments) {
        RunProperties runProps = null;
        Options o = new Options();
        CommandLineParser.addOptions(o);
        boolean parserError = false;
        try {
            runProps = new RunProperties(new GnuParser().parse(o, arguments), o);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Unable to start execution\n" + e.getMessage() + "\n"));
            parserError = true;
        }
        if (parserError || runProps.hasOption('h') || !runProps.hasOption('d') || !runProps.hasOption('n') || !runProps.hasOption('m') || !runProps.hasOption('s')) {
            new HelpFormatter().printHelp("Main", "ProtoCom: Prototype runner\n", o, "For documentation consult https://sdqweb.ipd.kit.edu/wiki/ProtoCom");
            System.exit(-1);
        }
        return runProps;
    }

    private static void addOptions(Options o) {
        o.addOption("h", "help", false, "Show this help");
        o.addOption("D", "debug", false, "Print debug information. Turn off for real experiments!");
        o.addOption("P", "passive", false, "Make server passive, no load drivers are started. No warmup runs are executed, either.");
        o.addOption("W", "warmup only", false, "Execute a number of runs equal to the warmup runs configuration. Depending on configuration, the inner times might be measured.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"propertyFile");
        OptionBuilder.withLongOpt((String)"propFile");
        OptionBuilder.withDescription((String)"Property file used to set default commandline parameters. Defaults can be overwritten by additional parameters.");
        o.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dataDirectory");
        OptionBuilder.withLongOpt((String)"dataDir");
        OptionBuilder.withDescription((String)"Datadirectory used by the FileStorage Sensor DAO to store the measured times [mandatory].");
        o.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"user count");
        OptionBuilder.withLongOpt((String)"threadcount");
        OptionBuilder.withDescription((String)"Override usage scenario population (only for closed workloads).");
        o.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"max measurements");
        OptionBuilder.withLongOpt((String)"maxmeasurement");
        OptionBuilder.withDescription((String)"Maximum measurements to take [mandatory]");
        o.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"warmup runs");
        OptionBuilder.withLongOpt((String)"warmup");
        OptionBuilder.withDescription((String)"Warmup runs before measuring (default: 1000).");
        o.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"calibrationPath");
        OptionBuilder.withLongOpt((String)"storeCalPath");
        OptionBuilder.withDescription((String)"Path to the directory where the calibration is stored [mandatory]");
        o.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ip");
        OptionBuilder.withLongOpt((String)"remoteAddr");
        OptionBuilder.withDescription((String)"Remote address of the RMI registry.");
        o.addOption(OptionBuilder.create((char)'R'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.withLongOpt((String)"remotePort");
        OptionBuilder.withDescription((String)"IP port of the RMI registry (default: 1099).");
        o.addOption(OptionBuilder.create((char)'O'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"seed");
        OptionBuilder.withLongOpt((String)"randomGenerator");
        OptionBuilder.withDescription((String)"Seed for the StoEx random generator.");
        o.addOption(OptionBuilder.create((char)'E'));
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)"Name of the experiment for use in the stored data [mandatory].");
        o.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"cpuStrategy");
        OptionBuilder.withArgName((String)"CPU Strategy");
        OptionBuilder.withDescription((String)"CPU calibration strategy: primes, count_numbers, fft, fibonacci, mandelbrot, sortarray, void, wait (default: Fibonacci).");
        o.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"hddStrategy");
        OptionBuilder.withArgName((String)"HDD Strategy");
        OptionBuilder.withDescription((String)"HDD calibration strategy: largeChunks (default: LargeChunks).");
        o.addOption(OptionBuilder.create((char)'H'));
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"accuracy");
        OptionBuilder.withArgName((String)"Accuracy");
        OptionBuilder.withDescription((String)"Accuracy of CPU and HDD calibration: LOW, MEDIUM, or HIGH (default: MEDIUM). ");
        o.addOption(OptionBuilder.create((char)'a'));
    }
}

