/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu;

import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.AbstractDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;

public class FFTDemand
extends AbstractDemandStrategy {
    private FastFourierTransformer ft = new FastFourierTransformer();

    public FFTDemand() {
        super(-1, -3, -5, 262144, 2);
    }

    private void fft(int lengthOfDistFunc) {
        Complex[] points = new Complex[lengthOfDistFunc];
        int i = 0;
        while (i < lengthOfDistFunc) {
            points[i] = new Complex(Math.random(), 0.0);
            ++i;
        }
        this.ft.transform(points);
    }

    @Override
    public void run(long initial) {
        int length = (int)initial;
        if (!FastFourierTransformer.isPowerOf2((long)length)) {
            int last;
            int next = FFTDemand.nextPowerOfTwo(length);
            length = next - length > length - (last = FFTDemand.lastPowerOfTwo(length)) || (long)next > this.defaultIterationCount ? last : next;
        }
        this.fft(length);
    }

    @Override
    public ResourceTypeEnum getStrategysResource() {
        return ResourceTypeEnum.CPU;
    }

    @Override
    public String getName() {
        return "FFT";
    }

    @Override
    public void cleanup() {
    }

    private static int nextPowerOfTwo(int i) {
        return Integer.highestOneBit(i) << 1;
    }

    private static int lastPowerOfTwo(int i) {
        return Integer.highestOneBit(i);
    }
}

