/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public final class SystemResourcesUtil {
    private static final OperatingSystemMXBean OS = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public static final File TEMP_DIR = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "ProtoCom");

    public static long getTotalPhysicalMemorySize() {
        return OS.getTotalPhysicalMemorySize();
    }

    public static long getFreePhysicalMemorySize() {
        return OS.getFreePhysicalMemorySize();
    }

    public static long getFreeTempDirectorySize() {
        return TEMP_DIR.getUsableSpace();
    }

    public static int getCPUCores() {
        return OS.getAvailableProcessors();
    }

    public static double getCPUProcessTimeNS() {
        return OS.getProcessCpuTime();
    }

    public static Amount<Duration> getCPUProcessTime() {
        return Amount.valueOf((double)SystemResourcesUtil.getCPUProcessTimeNS(), (Unit)SI.NANO((Unit)SI.SECOND));
    }
}

