/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.activeresource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.measure.quantity.Duration;
import org.apache.log4j.Logger;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.AbstractDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.CalibrationEntry;

public class CalibrationTable {
    public static final int DEFAULT_CALIBRATION_TABLE_SIZE = 11;
    protected CalibrationEntry[] table;
    private static final Logger LOGGER = Logger.getLogger((String)AbstractDemandStrategy.class.getName());

    public CalibrationTable() {
        this.table = new CalibrationEntry[11];
    }

    public CalibrationTable(int tableSize) {
        this.table = new CalibrationEntry[tableSize];
    }

    public static CalibrationTable load(File configFile) {
        CalibrationTable calibrationTable;
        block12: {
            calibrationTable = null;
            if (configFile.exists()) {
                LOGGER.debug((Object)("Loaded calibration from '" + configFile + "'"));
                calibrationTable = new CalibrationTable();
                InputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(configFile);
                        ObjectInputStream o = new ObjectInputStream(fis);
                        calibrationTable.setTable((CalibrationEntry[])o.readObject());
                        o.close();
                        break block12;
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("Error while loading " + configFile), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error((Object)("Error while reading " + configFile), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Error while reading " + configFile), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            LOGGER.debug((Object)(configFile + " not existing yet"));
        }
        return calibrationTable;
    }

    public void save(File configFile) {
        LOGGER.info((Object)("Saving calibration to '" + configFile + "'"));
        OutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(configFile);
                ObjectOutputStream o = new ObjectOutputStream(fos);
                o.writeObject(this.table);
                o.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error while writing calibration data", (Throwable)e);
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public byte[] toBinary() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(this.table);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static CalibrationTable fromBinary(byte[] binary) {
        CalibrationTable result = new CalibrationTable();
        CalibrationEntry[] table = null;
        ByteArrayInputStream in = new ByteArrayInputStream(binary);
        try {
            ObjectInputStream stream = new ObjectInputStream(in);
            table = (CalibrationEntry[])stream.readObject();
            result.setTable(table);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setTable(CalibrationEntry[] table) {
        this.table = table;
    }

    public CalibrationEntry getEntry(int entryNumber) {
        return this.table[entryNumber];
    }

    public void addEntry(int entryNumber, Amount<Duration> targetTime, long parameter) {
        this.table[entryNumber] = new CalibrationEntry(targetTime, parameter);
    }

    public int size() {
        return this.table.length;
    }
}

