/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu;

import java.util.Arrays;
import java.util.Random;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.AbstractDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;

public class SortArrayDemand
extends AbstractDemandStrategy {
    private static final int DEFAULT_ARRAY_SIZE = 0x100000;
    private double[] values = null;
    private final int arraySize;
    private static final int SEED = 1234;

    public SortArrayDemand(int arraySize) {
        super(-3, 0, 3, 10000, 50);
        this.arraySize = arraySize;
        this.values = new double[this.arraySize];
        Random r = new Random(1234L);
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = r.nextDouble();
            ++i;
        }
    }

    public SortArrayDemand() {
        this(0x100000);
    }

    private void sortArray(int amountOfNumbers) {
        int iterations = amountOfNumbers / this.arraySize;
        int rest = amountOfNumbers % this.arraySize;
        int i = 0;
        while (i < iterations) {
            double[] lotsOfDoubles = this.getArray(this.arraySize);
            Arrays.sort(lotsOfDoubles);
            ++i;
        }
        double[] lotsOfDoubles = this.getArray(rest);
        Arrays.sort(lotsOfDoubles);
    }

    private double[] getArray(int amountOfNumbers) {
        return Arrays.copyOf(this.values, amountOfNumbers);
    }

    @Override
    public void run(long initial) {
        this.sortArray((int)initial);
    }

    @Override
    public ResourceTypeEnum getStrategysResource() {
        return ResourceTypeEnum.CPU;
    }

    @Override
    public String getName() {
        return "SortArray";
    }

    @Override
    public void cleanup() {
    }
}

