package org.palladiosimulator.protocom.lang.java;

import java.util.Collection;
import org.palladiosimulator.protocom.lang.ICompilationUnit;

/**
 * Common attributes of Java compilation units.
 * 
 * @author Thomas Zolynski
 */
@SuppressWarnings("all")
public interface IJCompilationUnit extends ICompilationUnit {
  /**
   * Package name of this compilation unit.
   */
  String packageName();

  /**
   * Name of the compilation unit.
   */
  String compilationUnitName();

  /**
   * Collection of interface names which are either implemented or extended.
   */
  Collection<String> interfaces();

  /**
   * Methods (or signatures) defined by this compilation unit.
   */
  Collection<? extends IJMethod> methods();

  /**
   * Fields of this compilation unit.
   */
  Collection<? extends IJField> fields();
}
