package org.palladiosimulator.protocom.tech.rmi.repository;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJInterface;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaConstants;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.tech.ConceptMapping;

/**
 * Defining the content of component implementation interfaces (the interfaces for
 * the classes implementing the component behavior).
 * 
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoComposedStructureInterface extends ConceptMapping<InterfaceProvidingEntity> implements IJInterface {
  public PojoComposedStructureInterface(final InterfaceProvidingEntity pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String packageName() {
    return JavaNames.implementationPackage(this.pcmEntity);
  }

  @Override
  public String compilationUnitName() {
    return JavaNames.interfaceName(this.pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(JavaConstants.RMI_REMOTE_INTERFACE, JavaConstants.SERIALIZABLE_INTERFACE));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      JMethod _withParameters = new JMethod().withName("setContext").withParameters("Object myContext");
      Iterables.<JMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withParameters)));
      final Function1<ProvidedRole, Boolean> _function = (ProvidedRole it) -> {
        return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, JMethod> _function_1 = (ProvidedRole it) -> {
        return new JMethod().withName(JavaNames.portGetter(it)).withReturnType(JavaNames.fqn(((OperationProvidedRole) it).getProvidedInterface__OperationProvidedRole()));
      };
      Iterable<JMethod> _map = IterableExtensions.<ProvidedRole, JMethod>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function), _function_1);
      Iterables.<JMethod>addAll(results, _map);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJField> fields() {
    return null;
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.fqnInterface(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    return (_plus + ".java");
  }

  @Override
  public String projectName() {
    return null;
  }
}
