package org.palladiosimulator.protocom.tech.iiop.system;

import com.google.common.collect.ArrayListMultimap;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.tech.iiop.JavaEEIIOPReadMeFile;

@SuppressWarnings("all")
public class JavaEEIIOPReadMe extends JavaEEIIOPReadMeFile<org.palladiosimulator.pcm.system.System> {
  public JavaEEIIOPReadMe(final org.palladiosimulator.pcm.system.System pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String filePath() {
    return "ReadMe.txt";
  }

  @Override
  public String projectName() {
    return ".ReadMe";
  }

  @Override
  public HashMap<String, String> basicComponentClassName() {
    final HashMap<String, String> basicComponentClasses = CollectionLiterals.<String, String>newHashMap();
    EList<AssemblyContext> _assemblyContexts__ComposedStructure = this.pcmEntity.getAssemblyContexts__ComposedStructure();
    for (final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
      basicComponentClasses.put(
        JavaNames.fqnJavaEEBasicComponentProjectName(assemblyContext.getEncapsulatedComponent__AssemblyContext()), 
        JavaNames.fqnJavaEEBasicComponentClassName(assemblyContext.getEncapsulatedComponent__AssemblyContext()));
    }
    return basicComponentClasses;
  }

  @Override
  public ArrayListMultimap<String, String> basicComponentPortClassName() {
    final ArrayListMultimap<String, String> basicComponentPortClasses = ArrayListMultimap.<String, String>create();
    EList<AssemblyContext> _assemblyContexts__ComposedStructure = this.pcmEntity.getAssemblyContexts__ComposedStructure();
    for (final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
      {
        EList<ProvidedRole> providedRoles = assemblyContext.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity();
        LinkedList<String> portNames = CollectionLiterals.<String>newLinkedList();
        for (final ProvidedRole providedRole : providedRoles) {
          portNames.add(JavaNames.portClassName(providedRole));
        }
        basicComponentPortClasses.putAll(
          JavaNames.fqnJavaEEBasicComponentProjectName(assemblyContext.getEncapsulatedComponent__AssemblyContext()), portNames);
      }
    }
    return basicComponentPortClasses;
  }
}
