package org.palladiosimulator.protocom.tech.servlet.repository;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.protocom.lang.java.IJAnnotation;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JAnnotation;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.model.repository.BasicComponentAdapter;
import org.palladiosimulator.protocom.model.repository.OperationRequiredRoleAdapter;
import org.palladiosimulator.protocom.tech.servlet.ServletClass;

@SuppressWarnings("all")
public class ServletBasicComponentContextClass extends ServletClass<BasicComponent> {
  private final BasicComponentAdapter entity;

  public ServletBasicComponentContextClass(final BasicComponentAdapter entity, final BasicComponent pcmEntity) {
    super(pcmEntity);
    this.entity = entity;
  }

  @Override
  public String packageName() {
    return this.entity.getContextPackageFqn();
  }

  @Override
  public String compilationUnitName() {
    return this.entity.getContextClassName();
  }

  @Override
  public Collection<String> interfaces() {
    String _contextInterfaceName = this.entity.getContextInterfaceName();
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_contextInterfaceName));
  }

  @Override
  public Collection<? extends IJAnnotation> annotations() {
    JAnnotation _withValues = new JAnnotation().withName("com.fasterxml.jackson.annotation.JsonAutoDetect").withValues(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("fieldVisibility = com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.ANY")));
    return Collections.<IJAnnotation>unmodifiableList(CollectionLiterals.<IJAnnotation>newArrayList(_withValues));
  }

  @Override
  public Collection<? extends IJField> fields() {
    LinkedList<JField> _xblockexpression = null;
    {
      final LinkedList<JField> result = CollectionLiterals.<JField>newLinkedList();
      final Iterable<OperationRequiredRoleAdapter> requiredRoles = this.entity.getOperationRequiredRoles();
      final Function1<OperationRequiredRoleAdapter, JField> _function = (OperationRequiredRoleAdapter it) -> {
        return new JField().withType("String").withName(StringExtensions.toFirstLower(it.getSafeName()));
      };
      Iterable<JField> _map = IterableExtensions.<OperationRequiredRoleAdapter, JField>map(requiredRoles, _function);
      Iterables.<JField>addAll(result, _map);
      final Function1<OperationRequiredRoleAdapter, JField> _function_1 = (OperationRequiredRoleAdapter it) -> {
        JField _withType = new JField().withType(it.getRequiredInterface().getInterfaceFqn());
        String _firstLower = StringExtensions.toFirstLower(it.getSafeName());
        String _plus = ("portFor_" + _firstLower);
        return _withType.withName(_plus);
      };
      Iterable<JField> _map_1 = IterableExtensions.<OperationRequiredRoleAdapter, JField>map(requiredRoles, _function_1);
      Iterables.<JField>addAll(result, _map_1);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      LinkedList<JMethod> result = CollectionLiterals.<JMethod>newLinkedList();
      JMethod _jMethod = new JMethod();
      StringConcatenation _builder = new StringConcatenation();
      JMethod _withImplementation = _jMethod.withImplementation(_builder.toString());
      result.add(_withImplementation);
      int _length = ((Object[])Conversions.unwrapArray(this.entity.getOperationRequiredRoles(), Object.class)).length;
      boolean _greaterThan = (_length > 0);
      if (_greaterThan) {
        JMethod _jMethod_1 = new JMethod();
        StringConcatenation _builder_1 = new StringConcatenation();
        {
          Iterable<OperationRequiredRoleAdapter> _operationRequiredRoles = this.entity.getOperationRequiredRoles();
          boolean _hasElements = false;
          for(final OperationRequiredRoleAdapter role : _operationRequiredRoles) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder_1.appendImmediate(", ", "");
            }
            _builder_1.append("String ");
            String _firstLower = StringExtensions.toFirstLower(role.getSafeName());
            _builder_1.append(_firstLower);
            _builder_1.newLineIfNotEmpty();
          }
        }
        JMethod _withParameters = _jMethod_1.withParameters(_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        {
          Iterable<OperationRequiredRoleAdapter> _operationRequiredRoles_1 = this.entity.getOperationRequiredRoles();
          for(final OperationRequiredRoleAdapter role_1 : _operationRequiredRoles_1) {
            _builder_2.append("this.");
            String _firstLower_1 = StringExtensions.toFirstLower(role_1.getSafeName());
            _builder_2.append(_firstLower_1);
            _builder_2.append(" = ");
            String _firstLower_2 = StringExtensions.toFirstLower(role_1.getSafeName());
            _builder_2.append(_firstLower_2);
            _builder_2.append(";");
            _builder_2.newLineIfNotEmpty();
          }
        }
        JMethod _withImplementation_1 = _withParameters.withImplementation(_builder_2.toString());
        result.add(_withImplementation_1);
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      LinkedList<JMethod> result = CollectionLiterals.<JMethod>newLinkedList();
      final Function1<OperationRequiredRoleAdapter, JMethod> _function = (OperationRequiredRoleAdapter it) -> {
        JMethod _jMethod = new JMethod();
        String _safeName = it.getSafeName();
        String _plus = ("get" + _safeName);
        JMethod _withReturnType = _jMethod.withName(_plus).withReturnType("String");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return ");
        String _firstLower = StringExtensions.toFirstLower(it.getSafeName());
        _builder.append(_firstLower);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _withReturnType.withImplementation(_builder.toString());
      };
      Iterable<JMethod> _map = IterableExtensions.<OperationRequiredRoleAdapter, JMethod>map(this.entity.getOperationRequiredRoles(), _function);
      Iterables.<JMethod>addAll(result, _map);
      final Function1<OperationRequiredRoleAdapter, JMethod> _function_1 = (OperationRequiredRoleAdapter it) -> {
        JMethod _jMethod = new JMethod();
        String _safeName = it.getSafeName();
        String _plus = ("set" + _safeName);
        JMethod _withParameters = _jMethod.withName(_plus).withParameters("String port");
        StringConcatenation _builder = new StringConcatenation();
        String _firstLower = StringExtensions.toFirstLower(it.getSafeName());
        _builder.append(_firstLower);
        _builder.append(" = port;");
        _builder.newLineIfNotEmpty();
        return _withParameters.withImplementation(_builder.toString());
      };
      Iterable<JMethod> _map_1 = IterableExtensions.<OperationRequiredRoleAdapter, JMethod>map(this.entity.getOperationRequiredRoles(), _function_1);
      Iterables.<JMethod>addAll(result, _map_1);
      final Function1<OperationRequiredRoleAdapter, JMethod> _function_2 = (OperationRequiredRoleAdapter it) -> {
        JMethod _jMethod = new JMethod();
        String _safeName = it.getSafeName();
        String _plus = ("getPortFor" + _safeName);
        JAnnotation _withName = new JAnnotation().withName("com.fasterxml.jackson.annotation.JsonIgnore");
        JMethod _withAnnotations = _jMethod.withName(_plus).withReturnType(it.getRequiredInterface().getInterfaceFqn()).withAnnotations(
          Collections.<IJAnnotation>unmodifiableList(CollectionLiterals.<IJAnnotation>newArrayList(_withName)));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("portFor_");
        String _firstLower = StringExtensions.toFirstLower(it.getSafeName());
        _builder.append(_firstLower, "\t");
        _builder.append(" = (");
        String _interfaceFqn = it.getRequiredInterface().getInterfaceFqn();
        _builder.append(_interfaceFqn, "\t");
        _builder.append(") ");
        _builder.append(this.frameworkBase, "\t");
        _builder.append(".protocol.Registry.getInstance().lookup(");
        String _firstLower_1 = StringExtensions.toFirstLower(it.getSafeName());
        _builder.append(_firstLower_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("} catch (");
        _builder.append(this.frameworkBase);
        _builder.append(".protocol.RegistryException e) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("return portFor_");
        String _firstLower_2 = StringExtensions.toFirstLower(it.getSafeName());
        _builder.append(_firstLower_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _withAnnotations.withImplementation(_builder.toString());
      };
      Iterable<JMethod> _map_2 = IterableExtensions.<OperationRequiredRoleAdapter, JMethod>map(this.entity.getOperationRequiredRoles(), _function_2);
      Iterables.<JMethod>addAll(result, _map_2);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.fqnContext(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    return (_plus + ".java");
  }
}
