package org.palladiosimulator.protocom.traverse.jse.system;

import java.util.function.Consumer;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.impl.JClass;
import org.palladiosimulator.protocom.lang.java.impl.JInterface;
import org.palladiosimulator.protocom.lang.manifest.impl.JseManifest;
import org.palladiosimulator.protocom.lang.properties.impl.BuildProperties;
import org.palladiosimulator.protocom.lang.xml.impl.Classpath;
import org.palladiosimulator.protocom.lang.xml.impl.PluginXml;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructureContextClass;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructureContextInterface;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructureInterface;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructurePortClass;
import org.palladiosimulator.protocom.tech.rmi.system.PojoBuildProperties;
import org.palladiosimulator.protocom.tech.rmi.system.PojoClasspath;
import org.palladiosimulator.protocom.tech.rmi.system.PojoManifest;
import org.palladiosimulator.protocom.tech.rmi.system.PojoPluginXml;
import org.palladiosimulator.protocom.tech.rmi.system.PojoSystemClass;
import org.palladiosimulator.protocom.traverse.framework.system.XSystem;

/**
 * An System translates into the following Java compilation units:
 * <ul>
 * 	<li> a class used to setup the assembly (a System is a Composed Structure),
 * 	<li> an interface for this component's class,
 * 	<li> a context class for assembly (basically unused, can be removed?),
 * 	<li> an interface for the context class,
 *  <li> a class for each component's port, used by the Usage Scenario. TODO: Move to traverse
 * </ul>
 * 
 * @author Thomas Zolynski
 */
@SuppressWarnings("all")
public class JseSystem extends XSystem {
  @Override
  public void generate() {
    JInterface _instance = this.injector.<JInterface>getInstance(JInterface.class);
    PojoComposedStructureInterface _pojoComposedStructureInterface = new PojoComposedStructureInterface(this.entity);
    this.generatedFiles.add(_instance.createFor(_pojoComposedStructureInterface));
    JClass _instance_1 = this.injector.<JClass>getInstance(JClass.class);
    PojoSystemClass _pojoSystemClass = new PojoSystemClass(this.entity);
    this.generatedFiles.add(_instance_1.createFor(_pojoSystemClass));
    JClass _instance_2 = this.injector.<JClass>getInstance(JClass.class);
    PojoComposedStructureContextClass _pojoComposedStructureContextClass = new PojoComposedStructureContextClass(this.entity);
    this.generatedFiles.add(_instance_2.createFor(_pojoComposedStructureContextClass));
    JInterface _instance_3 = this.injector.<JInterface>getInstance(JInterface.class);
    PojoComposedStructureContextInterface _pojoComposedStructureContextInterface = new PojoComposedStructureContextInterface(this.entity);
    this.generatedFiles.add(_instance_3.createFor(_pojoComposedStructureContextInterface));
    final Consumer<ProvidedRole> _function = (ProvidedRole it) -> {
      JClass _instance_4 = this.injector.<JClass>getInstance(JClass.class);
      PojoComposedStructurePortClass _pojoComposedStructurePortClass = new PojoComposedStructurePortClass(it);
      this.generatedFiles.add(_instance_4.createFor(_pojoComposedStructurePortClass));
    };
    this.entity.getProvidedRoles_InterfaceProvidingEntity().forEach(_function);
    JseManifest _instance_4 = this.injector.<JseManifest>getInstance(JseManifest.class);
    PojoManifest _pojoManifest = new PojoManifest(this.entity);
    this.generatedFiles.add(_instance_4.createFor(_pojoManifest));
    PluginXml _instance_5 = this.injector.<PluginXml>getInstance(PluginXml.class);
    PojoPluginXml _pojoPluginXml = new PojoPluginXml(this.entity);
    this.generatedFiles.add(_instance_5.createFor(_pojoPluginXml));
    BuildProperties _instance_6 = this.injector.<BuildProperties>getInstance(BuildProperties.class);
    PojoBuildProperties _pojoBuildProperties = new PojoBuildProperties(this.entity);
    this.generatedFiles.add(_instance_6.createFor(_pojoBuildProperties));
    Classpath _instance_7 = this.injector.<Classpath>getInstance(Classpath.class);
    PojoClasspath _pojoClasspath = new PojoClasspath(this.entity);
    this.generatedFiles.add(_instance_7.createFor(_pojoClasspath));
  }
}
