package org.palladiosimulator.protocom.tech.pojo.repository;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.DataTypes;
import org.palladiosimulator.protocom.lang.java.util.JavaConstants;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.Parameters;
import org.palladiosimulator.protocom.tech.rmi.PojoInterface;

/**
 * Defining the content of OperationInterface classes.
 * 
 * @author Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoOperationInterface extends PojoInterface<OperationInterface> {
  public PojoOperationInterface(final OperationInterface entity) {
    super(entity);
  }

  @Override
  public Collection<String> interfaces() {
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(JavaConstants.RMI_REMOTE_INTERFACE));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    final Function1<OperationSignature, JMethod> _function = (OperationSignature it) -> {
      return new JMethod().withName(JavaNames.javaName(it)).withReturnType(DataTypes.getDataType(it.getReturnType__OperationSignature())).withParameters(Parameters.getParameterList(it)).withThrows(JavaConstants.RMI_REMOTE_EXCEPTION);
    };
    return ListExtensions.<OperationSignature, JMethod>map(this.pcmEntity.getSignatures__OperationInterface(), _function);
  }
}
