package org.palladiosimulator.protocom.tech.rmi.repository;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaConstants;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.tech.rmi.PojoClass;

/**
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoBasicComponentContextClass extends PojoClass<BasicComponent> {
  public PojoBasicComponentContextClass(final BasicComponent pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public Collection<? extends IJField> fields() {
    LinkedList<JField> _xblockexpression = null;
    {
      final LinkedList<JField> results = CollectionLiterals.<JField>newLinkedList();
      final Function1<RequiredRole, Boolean> _function = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, JField> _function_1 = (RequiredRole it) -> {
        return new JField().withType(JavaNames.fqn(((OperationRequiredRole) it).getRequiredInterface__OperationRequiredRole())).withName(StringExtensions.toFirstLower(JavaNames.javaName(it)));
      };
      Iterable<JField> _map = IterableExtensions.<RequiredRole, JField>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function), _function_1);
      Iterables.<JField>addAll(results, _map);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _jMethod = new JMethod();
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<RequiredRole, Boolean> _function = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, OperationRequiredRole> _function_1 = (RequiredRole it) -> {
        return ((OperationRequiredRole) it);
      };
      Iterable<OperationRequiredRole> _map = IterableExtensions.<RequiredRole, OperationRequiredRole>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function), _function_1);
      boolean _hasElements = false;
      for(final OperationRequiredRole role : _map) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _fqn = JavaNames.fqn(role.getRequiredInterface__OperationRequiredRole());
        _builder.append(_fqn);
        _builder.append("\t");
        String _firstLower = StringExtensions.toFirstLower(JavaNames.javaName(role));
        _builder.append(_firstLower);
        _builder.newLineIfNotEmpty();
      }
    }
    JMethod _withParameters = _jMethod.withParameters(_builder.toString());
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      final Function1<RequiredRole, Boolean> _function_2 = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, OperationRequiredRole> _function_3 = (RequiredRole it) -> {
        return ((OperationRequiredRole) it);
      };
      Iterable<OperationRequiredRole> _map_1 = IterableExtensions.<RequiredRole, OperationRequiredRole>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function_2), _function_3);
      for(final OperationRequiredRole role_1 : _map_1) {
        _builder_1.append("this.");
        String _firstLower_1 = StringExtensions.toFirstLower(JavaNames.javaName(role_1));
        _builder_1.append(_firstLower_1);
        _builder_1.append(" = ");
        String _firstLower_2 = StringExtensions.toFirstLower(JavaNames.javaName(role_1));
        _builder_1.append(_firstLower_2);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
      }
    }
    JMethod _withImplementation = _withParameters.withImplementation(_builder_1.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation));
  }

  @Override
  public String packageName() {
    return JavaNames.fqnContextPackage(this.pcmEntity);
  }

  @Override
  public String compilationUnitName() {
    return JavaNames.contextClassName(this.pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    String _contextInterfaceName = JavaNames.contextInterfaceName(this.pcmEntity);
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_contextInterfaceName, JavaConstants.SERIALIZABLE_INTERFACE));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      final Function1<RequiredRole, Boolean> _function = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, JMethod> _function_1 = (RequiredRole it) -> {
        JMethod _jMethod = new JMethod();
        String _javaName = JavaNames.javaName(it);
        String _plus = ("getRole" + _javaName);
        JMethod _withReturnType = _jMethod.withName(_plus).withReturnType(JavaNames.fqn(((OperationRequiredRole) it).getRequiredInterface__OperationRequiredRole()));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        String _firstLower = StringExtensions.toFirstLower(JavaNames.javaName(it));
        _builder.append(_firstLower);
        _builder.append(" == null) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("throw new RuntimeException(\"Attempt to retrieve unbounded port. Check your architecture! Role ");
        String _entityName = it.getEntityName();
        _builder.append(_entityName, "\t");
        _builder.append(" <");
        String _id = it.getId();
        _builder.append(_id, "\t");
        _builder.append("> RequiringEntity ");
        String _entityName_1 = it.getRequiringEntity_RequiredRole().getEntityName();
        _builder.append(_entityName_1, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return ");
        String _firstLower_1 = StringExtensions.toFirstLower(JavaNames.javaName(it));
        _builder.append(_firstLower_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _withReturnType.withImplementation(_builder.toString());
      };
      Iterable<JMethod> _map = IterableExtensions.<RequiredRole, JMethod>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function), _function_1);
      Iterables.<JMethod>addAll(results, _map);
      final Function1<RequiredRole, Boolean> _function_2 = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, JMethod> _function_3 = (RequiredRole it) -> {
        JMethod _jMethod = new JMethod();
        String _javaName = JavaNames.javaName(it);
        String _plus = ("setRole" + _javaName);
        JMethod _withName = _jMethod.withName(_plus);
        String _fqn = JavaNames.fqn(((OperationRequiredRole) it).getRequiredInterface__OperationRequiredRole());
        String _plus_1 = (_fqn + " newValue");
        JMethod _withParameters = _withName.withParameters(_plus_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("this.");
        String _firstLower = StringExtensions.toFirstLower(JavaNames.javaName(it));
        _builder.append(_firstLower);
        _builder.append(" = newValue;");
        return _withParameters.withImplementation(_builder.toString());
      };
      Iterable<JMethod> _map_1 = IterableExtensions.<RequiredRole, JMethod>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function_2), _function_3);
      Iterables.<JMethod>addAll(results, _map_1);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.fqnContext(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    return (_plus + ".java");
  }
}
