package org.palladiosimulator.protocom.tech.rmi.usage;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCalls;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.rmi.PojoClass;
import org.palladiosimulator.protocom.tech.rmi.util.PcmRMIProtoUserAction;

/**
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoUsageScenario extends PojoClass<UsageScenario> {
  public PojoUsageScenario(final UsageScenario pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _jMethod = new JMethod();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ctx = new de.uka.ipd.sdq.simucomframework.variables.StackContext();");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    {
      final Function1<EntryLevelSystemCall, OperationProvidedRole> _function = (EntryLevelSystemCall it) -> {
        return it.getProvidedRole_EntryLevelSystemCall();
      };
      Set<OperationProvidedRole> _set = IterableExtensions.<OperationProvidedRole>toSet(IterableExtensions.<EntryLevelSystemCall, OperationProvidedRole>map(PcmCalls.querySystemCalls(this.pcmEntity.getScenarioBehaviour_UsageScenario()), _function));
      for(final OperationProvidedRole providedRole : _set) {
        _builder.append("\t");
        String _contextInit = this.contextInit(providedRole);
        _builder.append(_contextInit, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("expRun = org.palladiosimulator.protocom.framework.java.se.experiment.ExperimentManager.getLatestExperimentRun();");
    _builder.newLine();
    _builder.append("ctx.getStack().createAndPushNewStackFrame();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory probFunctionFactory = de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl.getInstance();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("probFunctionFactory.setRandomGenerator(new de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator());");
    _builder.newLine();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache.initialiseStoExCache(probFunctionFactory);");
    _builder.newLine();
    JMethod _withImplementation = _jMethod.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation));
  }

  public String contextInit(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    String _portMemberVar = JavaNames.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = (");
    String _fqn = JavaNames.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn);
    _builder.append(")org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.lookup(\"");
    String _portClassName = JavaNames.portClassName(role);
    _builder.append(_portClassName);
    _builder.append("_\");");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  @Override
  public Collection<String> interfaces() {
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("java.lang.Runnable"));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    JMethod _withImplementation = new JMethod().withName("run").withImplementation("scenarioRunner();");
    JMethod _withName = new JMethod().withName("scenarioRunner");
    StringConcatenation _builder = new StringConcatenation();
    final Function1<AbstractUserAction, Boolean> _function = (AbstractUserAction it) -> {
      return Boolean.valueOf(Start.class.isInstance(it));
    };
    String _userActions = new PcmRMIProtoUserAction().userActions(((AbstractUserAction[])Conversions.unwrapArray(IterableExtensions.<AbstractUserAction>filter(this.pcmEntity.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour(), _function), AbstractUserAction.class))[0]);
    _builder.append(_userActions);
    _builder.newLineIfNotEmpty();
    JMethod _withImplementation_1 = _withName.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation, _withImplementation_1));
  }

  @Override
  public Collection<? extends IJField> fields() {
    LinkedList<JField> _xblockexpression = null;
    {
      final LinkedList<JField> results = CollectionLiterals.<JField>newLinkedList();
      JField _withType = new JField().withName("expRun").withType("de.uka.ipd.sdq.sensorframework.entities.ExperimentRun");
      results.add(_withType);
      JField _withType_1 = new JField().withName("ctx").withType(PcmCommons.stackContextClass());
      results.add(_withType_1);
      final Function1<EntryLevelSystemCall, OperationProvidedRole> _function = (EntryLevelSystemCall it) -> {
        return it.getProvidedRole_EntryLevelSystemCall();
      };
      final Function1<OperationProvidedRole, JField> _function_1 = (OperationProvidedRole it) -> {
        return new JField().withName(JavaNames.portMemberVar(((OperationProvidedRole) it))).withType(JavaNames.fqn(((OperationProvidedRole) it).getProvidedInterface__OperationProvidedRole()));
      };
      Iterable<JField> _map = IterableExtensions.<OperationProvidedRole, JField>map(IterableExtensions.<OperationProvidedRole>toSet(IterableExtensions.<EntryLevelSystemCall, OperationProvidedRole>map(PcmCalls.querySystemCalls(this.pcmEntity.getScenarioBehaviour_UsageScenario()), _function)), _function_1);
      Iterables.<JField>addAll(results, _map);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.implementationPackage(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    String _plus_1 = (_plus + "/");
    String _javaName = JavaNames.javaName(this.pcmEntity);
    String _plus_2 = (_plus_1 + _javaName);
    return (_plus_2 + ".java");
  }
}
