package org.palladiosimulator.protocom.tech.servlet.repository;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.tech.servlet.ServletInterface;

@SuppressWarnings("all")
public class ServletBasicComponentContextInterface extends ServletInterface<BasicComponent> {
  public ServletBasicComponentContextInterface(final BasicComponent pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String packageName() {
    return JavaNames.fqnContextPackage(this.pcmEntity);
  }

  @Override
  public String compilationUnitName() {
    return JavaNames.contextInterfaceName(this.pcmEntity);
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.fqnContextInterface(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    return (_plus + ".java");
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      final Function1<RequiredRole, Boolean> _function = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, JMethod> _function_1 = (RequiredRole it) -> {
        JMethod _jMethod = new JMethod();
        String _javaName = JavaNames.javaName(it);
        String _plus = ("get" + _javaName);
        return _jMethod.withName(_plus).withReturnType("String");
      };
      Iterable<JMethod> _map = IterableExtensions.<RequiredRole, JMethod>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function), _function_1);
      Iterables.<JMethod>addAll(results, _map);
      final Function1<RequiredRole, Boolean> _function_2 = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, JMethod> _function_3 = (RequiredRole it) -> {
        JMethod _jMethod = new JMethod();
        String _javaName = JavaNames.javaName(it);
        String _plus = ("set" + _javaName);
        return _jMethod.withName(_plus).withParameters("String port");
      };
      Iterable<JMethod> _map_1 = IterableExtensions.<RequiredRole, JMethod>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function_2), _function_3);
      Iterables.<JMethod>addAll(results, _map_1);
      final Function1<RequiredRole, Boolean> _function_4 = (RequiredRole it) -> {
        return Boolean.valueOf(OperationRequiredRole.class.isInstance(it));
      };
      final Function1<RequiredRole, JMethod> _function_5 = (RequiredRole it) -> {
        JMethod _jMethod = new JMethod();
        String _javaName = JavaNames.javaName(it);
        String _plus = ("getPortFor" + _javaName);
        return _jMethod.withName(_plus).withReturnType(JavaNames.fqn(((OperationRequiredRole) it).getRequiredInterface__OperationRequiredRole()));
      };
      Iterable<JMethod> _map_2 = IterableExtensions.<RequiredRole, JMethod>map(IterableExtensions.<RequiredRole>filter(this.pcmEntity.getRequiredRoles_InterfaceRequiringEntity(), _function_4), _function_5);
      Iterables.<JMethod>addAll(results, _map_2);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }
}
