package org.palladiosimulator.protocom.traverse.framework.repository;

import java.util.Arrays;
import java.util.function.Consumer;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.protocom.traverse.framework.PcmRepresentative;

/**
 * Traversing Repository. Child elements are:
 * <ul>
 * 	<li>Basic Component,
 * 	<li>Composite Component,
 * 	<li>Infrastructure Interface,
 * 	<li>Operation Interface,
 * 	<li>Event Groups,
 *  <li>Data Types.
 * </ul>
 * 
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class XRepository extends PcmRepresentative<Repository> {
  @Override
  public void traverse() {
    final Consumer<Interface> _function = (Interface it) -> {
      this.createInterface(it);
    };
    this.entity.getInterfaces__Repository().forEach(_function);
    final Consumer<RepositoryComponent> _function_1 = (RepositoryComponent it) -> {
      this.createComponent(it);
    };
    this.entity.getComponents__Repository().forEach(_function_1);
    final Consumer<DataType> _function_2 = (DataType it) -> {
      this.createDataType(it);
    };
    this.entity.getDataTypes__Repository().forEach(_function_2);
  }

  /**
   * Traverse through Composite Components.
   */
  protected void _createComponent(final CompositeComponent componentEntity) {
    this.injector.<XCompositeComponent>getInstance(XCompositeComponent.class).setEntity(componentEntity).transform();
  }

  /**
   * Traverse through Basic Components.
   */
  protected void _createComponent(final BasicComponent componentEntity) {
    this.injector.<XBasicComponent>getInstance(XBasicComponent.class).setEntity(componentEntity).transform();
  }

  /**
   * Fallback for component traversing.
   */
  protected void _createComponent(final Entity componentEntity) {
    throw new UnsupportedOperationException("Unsupported component type.");
  }

  /**
   * Traverse through Infrastructure Interfaces.
   */
  protected void _createInterface(final InfrastructureInterface interfaceEntity) {
    this.injector.<XInfrastructureInterface>getInstance(XInfrastructureInterface.class).setEntity(interfaceEntity).transform();
  }

  /**
   * Traverse through Operation Interfaces.
   */
  protected void _createInterface(final OperationInterface interfaceEntity) {
    this.injector.<XOperationInterface>getInstance(XOperationInterface.class).setEntity(interfaceEntity).transform();
  }

  /**
   * Traverse through Event Groups.
   */
  protected void _createInterface(final EventGroup interfaceEntity) {
    this.injector.<XEventGroup>getInstance(XEventGroup.class).setEntity(interfaceEntity).transform();
  }

  /**
   * Traverse through Data Types.
   */
  protected void _createDataType(final DataType typeEntity) {
    throw new UnsupportedOperationException("Unsupported data type.");
  }

  /**
   * Traverse through Primitive Data Types.
   */
  protected void _createDataType(final PrimitiveDataType typeEntity) {
    return;
  }

  /**
   * Traverse through Composite Data Types.
   */
  protected void _createDataType(final CompositeDataType typeEntity) {
    this.injector.<XCompositeDataType>getInstance(XCompositeDataType.class).setEntity(typeEntity).transform();
  }

  /**
   * Traverse through Collection Data Types.
   */
  protected void _createDataType(final CollectionDataType typeEntity) {
    this.injector.<XCollectionDataType>getInstance(XCollectionDataType.class).setEntity(typeEntity).transform();
  }

  public void createComponent(final Entity componentEntity) {
    if (componentEntity instanceof BasicComponent) {
      _createComponent((BasicComponent)componentEntity);
      return;
    } else if (componentEntity instanceof CompositeComponent) {
      _createComponent((CompositeComponent)componentEntity);
      return;
    } else if (componentEntity != null) {
      _createComponent(componentEntity);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(componentEntity).toString());
    }
  }

  public void createInterface(final Interface interfaceEntity) {
    if (interfaceEntity instanceof EventGroup) {
      _createInterface((EventGroup)interfaceEntity);
      return;
    } else if (interfaceEntity instanceof InfrastructureInterface) {
      _createInterface((InfrastructureInterface)interfaceEntity);
      return;
    } else if (interfaceEntity instanceof OperationInterface) {
      _createInterface((OperationInterface)interfaceEntity);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(interfaceEntity).toString());
    }
  }

  public void createDataType(final DataType typeEntity) {
    if (typeEntity instanceof CollectionDataType) {
      _createDataType((CollectionDataType)typeEntity);
      return;
    } else if (typeEntity instanceof CompositeDataType) {
      _createDataType((CompositeDataType)typeEntity);
      return;
    } else if (typeEntity instanceof PrimitiveDataType) {
      _createDataType((PrimitiveDataType)typeEntity);
      return;
    } else if (typeEntity != null) {
      _createDataType(typeEntity);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(typeEntity).toString());
    }
  }
}
