package org.palladiosimulator.protocom.traverse.jee.system;

import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.protocom.lang.java.impl.JeeClass;
import org.palladiosimulator.protocom.lang.txt.impl.JeeReadMe;
import org.palladiosimulator.protocom.lang.xml.impl.JeeClasspath;
import org.palladiosimulator.protocom.tech.iiop.repository.JavaEEIIOPBasicComponentClass;
import org.palladiosimulator.protocom.tech.iiop.system.JavaEEIIOPClasspath;
import org.palladiosimulator.protocom.tech.iiop.system.JavaEEIIOPClientClasspath;
import org.palladiosimulator.protocom.tech.iiop.system.JavaEEIIOPReadMe;
import org.palladiosimulator.protocom.traverse.framework.system.XSystem;

@SuppressWarnings("all")
public class JeeSystem extends XSystem {
  @Override
  public void generate() {
    final Set<AssemblyConnector> assemblyConnectorSet = IterableExtensions.<AssemblyConnector>toSet(Iterables.<AssemblyConnector>filter(this.entity.getConnectors__ComposedStructure(), AssemblyConnector.class));
    final EList<AssemblyContext> repositoryComponentList = this.entity.getAssemblyContexts__ComposedStructure();
    final Function1<AssemblyContext, Boolean> _function = (AssemblyContext it) -> {
      return Boolean.valueOf(BasicComponent.class.isInstance(it.getEncapsulatedComponent__AssemblyContext()));
    };
    final Function1<AssemblyContext, BasicComponent> _function_1 = (AssemblyContext it) -> {
      RepositoryComponent _encapsulatedComponent__AssemblyContext = it.getEncapsulatedComponent__AssemblyContext();
      return ((BasicComponent) _encapsulatedComponent__AssemblyContext);
    };
    final Consumer<BasicComponent> _function_2 = (BasicComponent it) -> {
      JeeClasspath _instance = this.injector.<JeeClasspath>getInstance(JeeClasspath.class);
      JavaEEIIOPClasspath _javaEEIIOPClasspath = new JavaEEIIOPClasspath(it, assemblyConnectorSet);
      this.generatedFiles.add(
        _instance.createFor(_javaEEIIOPClasspath));
    };
    IterableExtensions.<AssemblyContext, BasicComponent>map(IterableExtensions.<AssemblyContext>filter(repositoryComponentList, _function), _function_1).forEach(_function_2);
    final Function1<AssemblyContext, Boolean> _function_3 = (AssemblyContext it) -> {
      return Boolean.valueOf(BasicComponent.class.isInstance(it.getEncapsulatedComponent__AssemblyContext()));
    };
    final Function1<AssemblyContext, BasicComponent> _function_4 = (AssemblyContext it) -> {
      RepositoryComponent _encapsulatedComponent__AssemblyContext = it.getEncapsulatedComponent__AssemblyContext();
      return ((BasicComponent) _encapsulatedComponent__AssemblyContext);
    };
    final Consumer<BasicComponent> _function_5 = (BasicComponent it) -> {
      JeeClasspath _instance = this.injector.<JeeClasspath>getInstance(JeeClasspath.class);
      JavaEEIIOPClientClasspath _javaEEIIOPClientClasspath = new JavaEEIIOPClientClasspath(it);
      this.generatedFiles.add(_instance.createFor(_javaEEIIOPClientClasspath));
    };
    IterableExtensions.<AssemblyContext, BasicComponent>map(IterableExtensions.<AssemblyContext>filter(repositoryComponentList, _function_3), _function_4).forEach(_function_5);
    final Function1<AssemblyContext, Boolean> _function_6 = (AssemblyContext it) -> {
      return Boolean.valueOf(BasicComponent.class.isInstance(it.getEncapsulatedComponent__AssemblyContext()));
    };
    final Function1<AssemblyContext, BasicComponent> _function_7 = (AssemblyContext it) -> {
      RepositoryComponent _encapsulatedComponent__AssemblyContext = it.getEncapsulatedComponent__AssemblyContext();
      return ((BasicComponent) _encapsulatedComponent__AssemblyContext);
    };
    final Consumer<BasicComponent> _function_8 = (BasicComponent it) -> {
      JeeClass _instance = this.injector.<JeeClass>getInstance(JeeClass.class);
      JavaEEIIOPBasicComponentClass _javaEEIIOPBasicComponentClass = new JavaEEIIOPBasicComponentClass(it, assemblyConnectorSet);
      this.generatedFiles.add(
        _instance.createFor(_javaEEIIOPBasicComponentClass));
    };
    IterableExtensions.<AssemblyContext, BasicComponent>map(IterableExtensions.<AssemblyContext>filter(repositoryComponentList, _function_6), _function_7).forEach(_function_8);
    JeeReadMe _instance = this.injector.<JeeReadMe>getInstance(JeeReadMe.class);
    JavaEEIIOPReadMe _javaEEIIOPReadMe = new JavaEEIIOPReadMe(this.entity);
    this.generatedFiles.add(_instance.createFor(_javaEEIIOPReadMe));
  }
}
