package org.palladiosimulator.protocom.tech.iiop.repository;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.iiop.JavaEEIIOPClass;

@SuppressWarnings("all")
public class JavaEEIIOPBasicComponentPortClass extends JavaEEIIOPClass<ProvidedRole> {
  public JavaEEIIOPBasicComponentPortClass(final ProvidedRole pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String superClass() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.palladiosimulator.protocom.framework.java.se.port.AbstractPerformancePrototypeBasicPort<");
    String _fqnJavaEEComponentPortSuperClass = JavaNames.fqnJavaEEComponentPortSuperClass(this.pcmEntity.getProvidingEntity_ProvidedRole());
    _builder.append(_fqnJavaEEComponentPortSuperClass);
    _builder.append(">");
    return _builder.toString();
  }

  @Override
  public String packageName() {
    return JavaNames.fqnJavaEEPortPackage(this.pcmEntity);
  }

  @Override
  public String compilationUnitName() {
    return JavaNames.portClassName(this.pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    String _providedRoleInterface = this.providedRoleInterface(this.pcmEntity);
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_providedRoleInterface));
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _withThrows = new JMethod().withThrows("java.rmi.RemoteException");
    JMethod _withParameters = new JMethod().withParameters("String assemblyContext");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("addVisitor(org.palladiosimulator.protocom.framework.java.se.visitor.SensorFrameworkVisitor.getInstance());");
    _builder.newLine();
    JMethod _withThrows_1 = _withParameters.withImplementation(_builder.toString()).withThrows("java.rmi.RemoteException");
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withThrows, _withThrows_1));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    return this.providedRoleMethods(this.pcmEntity);
  }

  @Override
  public String filePath() {
    return JavaNames.fqnJavaEEBasicComponentPortClassPath(this.pcmEntity);
  }

  @Override
  public String projectName() {
    return JavaNames.fqnJavaEEBasicComponentPortProjectName(this.pcmEntity);
  }

  protected List<JMethod> _providedRoleMethods(final OperationProvidedRole role) {
    final Function1<OperationSignature, JMethod> _function = (OperationSignature it) -> {
      JMethod _withParameters = new JMethod().withName(JavaNames.javaSignature(it)).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList());
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("preCallVisitor(ctx, \"");
      String _serviceName = JavaNames.serviceName(it);
      _builder.append(_serviceName);
      _builder.append("\");");
      _builder.newLineIfNotEmpty();
      _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> result = myComponent.");
      String _serviceName_1 = JavaNames.serviceName(it);
      _builder.append(_serviceName_1);
      _builder.append("(ctx);");
      _builder.newLineIfNotEmpty();
      _builder.append("postCallVisitor(ctx, \"");
      String _serviceName_2 = JavaNames.serviceName(it);
      _builder.append(_serviceName_2);
      _builder.append("\");");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("return result;");
      _builder.newLine();
      return _withParameters.withImplementation(_builder.toString());
    };
    return ListExtensions.<OperationSignature, JMethod>map(role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface(), _function);
  }

  protected List<JMethod> _providedRoleMethods(final InfrastructureProvidedRole role) {
    final Function1<InfrastructureSignature, JMethod> _function = (InfrastructureSignature it) -> {
      return new JMethod().withName(JavaNames.javaSignature(it)).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList()).withImplementation("return null;");
    };
    return ListExtensions.<InfrastructureSignature, JMethod>map(role.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface(), _function);
  }

  protected String _providedRoleInterface(final OperationProvidedRole role) {
    return JavaNames.fqnJavaEEComponentPortInterface(role);
  }

  protected String _providedRoleInterface(final InfrastructureProvidedRole role) {
    return JavaNames.fqnJavaEEComponentPortInterface(role);
  }

  @Override
  public Collection<? extends IJField> jeeClassDependencyInjection() {
    LinkedList<JField> _xblockexpression = null;
    {
      final LinkedList<JField> results = CollectionLiterals.<JField>newLinkedList();
      JField _withType = new JField().withName("myComponent").withType(JavaNames.javaName(this.pcmEntity.getProvidingEntity_ProvidedRole()));
      Iterables.<JField>addAll(results, Collections.<JField>unmodifiableList(CollectionLiterals.<JField>newArrayList(_withType)));
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  public List<JMethod> providedRoleMethods(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _providedRoleMethods((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _providedRoleMethods((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public String providedRoleInterface(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _providedRoleInterface((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _providedRoleInterface((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }
}
