package org.palladiosimulator.protocom.tech.iiop.repository;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.tech.iiop.JavaEEIIOPDescriptor;

@SuppressWarnings("all")
public class JavaEEIIOPGlassfishEjbDescriptor extends JavaEEIIOPDescriptor<AllocationContext> {
  private final Allocation allocation = this.pcmEntity.getAllocation_AllocationContext();

  private HashMap<AssemblyConnector, String> assemblyConnectorIPHashMap = CollectionLiterals.<AssemblyConnector, String>newHashMap();

  public JavaEEIIOPGlassfishEjbDescriptor(final AllocationContext pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String ejbName() {
    return JavaNames.javaName(this.pcmEntity.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext());
  }

  @Override
  public Collection<String> ejbRefName() {
    return null;
  }

  @Override
  public String jndiName() {
    return null;
  }

  @Override
  public String filePath() {
    String _fqnJavaEEDescriptorPath = JavaNames.fqnJavaEEDescriptorPath(
      this.pcmEntity.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext());
    return (_fqnJavaEEDescriptorPath + "glassfish-ejb-jar.xml");
  }

  @Override
  public String projectName() {
    return JavaNames.fqnJavaEEDescriptorProjectName(
      this.pcmEntity.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext());
  }

  @Override
  public HashMap<AssemblyConnector, String> requiredComponentsAndResourceContainerIPAddress() {
    final Function1<AssemblyConnector, Boolean> _function = (AssemblyConnector it) -> {
      return Boolean.valueOf(it.getRequiredRole_AssemblyConnector().getRequiringEntity_RequiredRole().equals(
        this.pcmEntity.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext()));
    };
    final Iterable<AssemblyConnector> basicComponentAssemblyConnectors = IterableExtensions.<AssemblyConnector>filter(Iterables.<AssemblyConnector>filter(this.allocation.getSystem_Allocation().getConnectors__ComposedStructure(), 
      AssemblyConnector.class), _function);
    for (final AssemblyConnector connector : basicComponentAssemblyConnectors) {
      {
        final Function1<AllocationContext, Boolean> _function_1 = (AllocationContext it) -> {
          return Boolean.valueOf(it.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(
            connector.getProvidedRole_AssemblyConnector().getProvidingEntity_ProvidedRole()));
        };
        Iterable<AllocationContext> requiredEntityAllocationContext = IterableExtensions.<AllocationContext>filter(this.allocation.getAllocationContexts_Allocation(), _function_1);
        for (final AllocationContext allocationContext : requiredEntityAllocationContext) {
          {
            ResourceContainer resourceContainer = allocationContext.getResourceContainer_AllocationContext();
            EList<StereotypeApplication> resourceContainerAppliedStereotypes = StereotypeAPI.getStereotypeApplications(resourceContainer, "IIOP");
            boolean _notEquals = (!Objects.equal(resourceContainerAppliedStereotypes, null));
            if (_notEquals) {
              for (final StereotypeApplication stereotypeApplication : resourceContainerAppliedStereotypes) {
                {
                  String ipValue = stereotypeApplication.eGet(stereotypeApplication.getExtension().getSource().getTaggedValue("IpAddress")).toString();
                  this.assemblyConnectorIPHashMap.put(connector, ipValue);
                }
              }
            } else {
              this.assemblyConnectorIPHashMap.put(connector, "localhost");
            }
          }
        }
      }
    }
    return this.assemblyConnectorIPHashMap;
  }
}
