/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.tests;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.protocom.framework.java.se.strategies.PassiveResource;
import org.palladiosimulator.protocom.framework.java.se.strategies.PassiveResourceRegistry;

public class PassiveResourcesTest {
    private static final int CAPACITY = 1;
    private static final String PR1 = "pr1";
    private static final String PR2 = "pr2";

    @Before
    public void initialise() {
        PassiveResource pr1 = new PassiveResource(1, PR1);
        PassiveResource pr2 = new PassiveResource(2, PR2);
        PassiveResourceRegistry.singleton().addPassiveResource(pr1);
        PassiveResourceRegistry.singleton().addPassiveResource(pr2);
        Logger.getLogger((String)PassiveResource.class.getName()).addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
    }

    @Test
    public void testPassiveResources() throws IOException, InterruptedException {
        ThreadGroup tg = new ThreadGroup("Acquiring Threads");
        PassiveResourceRegistry.singleton().getResource(PR1).acquire();
        AcquiringThread at = new AcquiringThread();
        new Thread(tg, at).start();
        Thread.sleep(1000L);
        Assert.assertTrue((tg.activeCount() == 1 ? 1 : 0) != 0);
        PassiveResourceRegistry.singleton().getResource(PR1).release();
        Thread.sleep(100L);
        Assert.assertTrue((tg.activeCount() == 0 ? 1 : 0) != 0);
        PassiveResourceRegistry.singleton().getResource(PR2).acquire();
        PassiveResourceRegistry.singleton().getResource(PR2).acquire();
        PassiveResourceRegistry.singleton().getResource(PR2).release();
        PassiveResourceRegistry.singleton().getResource(PR2).release();
        TryingThread tt = new TryingThread();
        new Thread(tg, tt).start();
        Thread.sleep(100L);
    }

    class AcquiringThread
    implements Runnable {
        AcquiringThread() {
        }

        @Override
        public void run() {
            PassiveResourceRegistry.singleton().getResource(PassiveResourcesTest.PR1).acquire();
            Logger.getLogger((String)PassiveResource.class.getName()).debug((Object)"ACQUIRED! ");
        }
    }

    class TryingThread
    implements Runnable {
        TryingThread() {
        }

        @Override
        public void run() {
            PassiveResourceRegistry.singleton().getResource(PassiveResourcesTest.PR2).acquire();
            PassiveResourceRegistry.singleton().getResource(PassiveResourcesTest.PR2).acquire();
            PassiveResourceRegistry.singleton().getResource(PassiveResourcesTest.PR2).acquire();
            Assert.assertTrue((boolean)false);
        }
    }
}

