/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.tests;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.palladiosimulator.protocom.framework.java.se.strategies.DemandConsumerStrategiesRegistry;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.FibonacciDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.hdd.ReadLargeChunksDemand;

public class PrototypePlatformTests {
    private static final double CPU_PROCESSING_RATE = 1000.0;
    private static final double HDD_PROCESSING_RATE = 1000.0;
    private static final String CALIBRATION_PATH = "../..";
    private static final Logger LOGGER = Logger.getLogger((String)PrototypePlatformTests.class.getName());

    @BeforeClass
    public static void setUp() {
        LOGGER.setLevel(Level.INFO);
        LOGGER.info((Object)"Initialising Testbed");
        FibonacciDemand cpuStrategy = new FibonacciDemand();
        cpuStrategy.initializeStrategy(DegreeOfAccuracyEnum.HIGH, 1000.0, CALIBRATION_PATH);
        cpuStrategy.ensureCalibrationExists();
        DemandConsumerStrategiesRegistry.singleton().registerStrategyFor(ResourceTypeEnum.CPU, (IDemandStrategy)cpuStrategy);
        ReadLargeChunksDemand hddStrategy = new ReadLargeChunksDemand();
        hddStrategy.initializeStrategy(DegreeOfAccuracyEnum.MEDIUM, 1000.0, CALIBRATION_PATH);
        hddStrategy.ensureCalibrationExists();
        DemandConsumerStrategiesRegistry.singleton().registerStrategyFor(ResourceTypeEnum.HDD, (IDemandStrategy)hddStrategy);
        LOGGER.info((Object)"Testbed inialised");
    }

    @Test
    public void testConsumeCPU() {
        double ERROR_LEVEL = 0.1;
        boolean TEST_ITERATIONS = true;
        double OUTLIER_RATIO = 1.0;
        int START_UNIT = 512;
        long unitsToConsume = 512L;
        while (unitsToConsume <= 2048L) {
            this.testConsumeCPUUnits(0.1, 1, 1.0, unitsToConsume);
            unitsToConsume *= 2L;
        }
    }

    @Test
    public void testConsumeHDD() throws IOException {
        ReadLargeChunksDemand hddStrategy = (ReadLargeChunksDemand)DemandConsumerStrategiesRegistry.singleton().getStrategyFor(ResourceTypeEnum.HDD);
        Assert.assertEquals(hddStrategy.getClass(), ReadLargeChunksDemand.class);
        BufferedWriter bw = new BufferedWriter(new FileWriter("testConsumeHDDResults.csv"));
        bw.write("SizeRead;Time");
        bw.newLine();
        hddStrategy.initializeStrategy(DegreeOfAccuracyEnum.MEDIUM, 0.0, CALIBRATION_PATH);
        hddStrategy.ensureCalibrationExists();
        boolean random = true;
        int iterations = 100;
        double demand = 1000000.0;
        int i = 0;
        while (i < 100) {
            hddStrategy.consume(1000000.0);
            ++i;
        }
        this.consumeRandomHDDDemand(hddStrategy, bw, 100);
    }

    private void testConsumeCPUUnits(double ERROR_LEVEL, int TEST_ITERATIONS, double OUTLIER_RATIO, long unitsToConsume) {
        double lowerAcceptanceBound = ((double)unitsToConsume - (double)unitsToConsume * ERROR_LEVEL / 2.0) / 1000.0;
        double upperAcceptanceBound = ((double)unitsToConsume + (double)unitsToConsume * ERROR_LEVEL / 2.0) / 1000.0;
        IDemandStrategy cpuStrategy = DemandConsumerStrategiesRegistry.singleton().getStrategyFor(ResourceTypeEnum.CPU);
        int countOutliers = 0;
        int i = 0;
        while (i < TEST_ITERATIONS) {
            long start = System.nanoTime();
            cpuStrategy.consume((double)unitsToConsume);
            long end = System.nanoTime();
            double timeConsumptionInSeconds = (double)(end - start) / 1.0E9;
            if (timeConsumptionInSeconds < lowerAcceptanceBound || timeConsumptionInSeconds > upperAcceptanceBound) {
                ++countOutliers;
                if (timeConsumptionInSeconds < lowerAcceptanceBound) {
                    LOGGER.info((Object)("Lower acceptance level not reached in run " + i + ": Time is " + timeConsumptionInSeconds + " and must be higher than " + lowerAcceptanceBound));
                }
                if (timeConsumptionInSeconds > upperAcceptanceBound) {
                    LOGGER.info((Object)("Upper acceptance level not reached in run " + i + ": Time is " + timeConsumptionInSeconds + " and must be lower than " + upperAcceptanceBound));
                }
            }
            ++i;
        }
        LOGGER.info((Object)("There have been " + countOutliers + " outliers out of " + TEST_ITERATIONS + " values for " + unitsToConsume + " workunits."));
        Assert.assertTrue((String)("There have been more than " + (double)TEST_ITERATIONS * OUTLIER_RATIO + " outliers for " + unitsToConsume + " work units: " + countOutliers), ((double)countOutliers <= (double)TEST_ITERATIONS * OUTLIER_RATIO ? 1 : 0) != 0);
    }

    private void consumeRandomHDDDemand(ReadLargeChunksDemand hddStrategy, BufferedWriter bw, int iterations) throws IOException {
        double[] demand = new double[iterations];
        long[] startTime = new long[iterations];
        long[] endTime = new long[iterations];
        int i = 0;
        while (i < iterations) {
            demand[i] = Math.random() * (double)hddStrategy.getMaxFileSize();
            startTime[i] = System.nanoTime();
            hddStrategy.consume(demand[i]);
            endTime[i] = System.nanoTime();
            ++i;
        }
        i = 0;
        while (i < iterations) {
            this.writeHDDResultToFile(bw, startTime[i], endTime[i], demand[i], i);
            ++i;
        }
    }

    private void consumeDecreasingHDDDemand(ReadLargeChunksDemand hddStrategy, BufferedWriter bw, int iterations) throws IOException {
        long[] startTimes = new long[iterations];
        long[] endTimes = new long[iterations];
        int j = hddStrategy.getMaxFileSize();
        while (j > 0) {
            double demand = j;
            int i = 0;
            while (i < iterations) {
                startTimes[i] = System.nanoTime();
                hddStrategy.consume(demand);
                endTimes[i] = System.nanoTime();
                ++i;
            }
            long sum = 0L;
            i = 0;
            while (i < iterations) {
                sum += endTimes[i] - startTimes[i];
                this.writeHDDResultToFile(bw, startTimes[i], endTimes[i], demand, i);
                ++i;
            }
            double mean = (double)sum / (double)iterations;
            System.out.println("Mean is " + mean + " nanoseconds, that is " + mean / 1.0E9 + " seconds.");
            j -= 1000000;
        }
    }

    private void writeHDDResultToFile(BufferedWriter bw, long startTime, long endTime, double demand, int i) throws IOException {
        System.out.println(String.valueOf(i) + ": Reading " + demand + " B took " + (endTime - startTime) + " ns.");
        bw.write(String.valueOf(demand) + ";" + (endTime - startTime));
        bw.newLine();
        bw.flush();
    }
}

