/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.workflow;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.AbstractConfigurationTab;
import org.palladiosimulator.editors.commons.dialogs.selection.PalladioSelectEObjectDialog;

public class ProtoComGenerationConfigurationTab
extends AbstractConfigurationTab {
    protected Combo comboModelToTextTarget;
    private Text variableText;
    private Text minimumText;
    private Text maximumText;
    private Text stepWidthText;
    private ArrayList<String> modelFiles = new ArrayList();

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.variableText.setText(configuration.getAttribute("variable", ""));
        }
        catch (CoreException e) {
            this.variableText.setText("");
        }
        try {
            this.minimumText.setText(configuration.getAttribute("minimum", ""));
        }
        catch (CoreException e) {
            this.minimumText.setText("");
        }
        try {
            this.maximumText.setText(configuration.getAttribute("maximum", ""));
        }
        catch (CoreException e) {
            this.maximumText.setText("");
        }
        try {
            this.stepWidthText.setText(configuration.getAttribute("stepwidth", ""));
        }
        catch (CoreException e) {
            this.stepWidthText.setText("");
        }
        try {
            this.modelFiles.clear();
            this.modelFiles.add(configuration.getAttribute("repositoryFile", ""));
            this.modelFiles.add(configuration.getAttribute("systemFile", ""));
            this.modelFiles.add(configuration.getAttribute("allocationFile", ""));
            this.modelFiles.add(configuration.getAttribute("usageFile", ""));
        }
        catch (CoreException e) {
            this.stepWidthText.setText("");
        }
        try {
            String solverStr = configuration.getAttribute("modelToTextTarget", "Java SE RMI Performance Prototype");
            String[] items = this.comboModelToTextTarget.getItems();
            int i = 0;
            while (i < items.length) {
                String str = items[i];
                if (str.equals(solverStr)) {
                    this.comboModelToTextTarget.select(i);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.comboModelToTextTarget.select(0);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("variable", this.variableText.getText());
        configuration.setAttribute("minimum", this.minimumText.getText());
        configuration.setAttribute("maximum", this.maximumText.getText());
        configuration.setAttribute("stepwidth", this.stepWidthText.getText());
        configuration.setAttribute("modelToTextTarget", this.comboModelToTextTarget.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("clear", false);
    }

    protected void createFurtherSections(Composite container) {
        Group sensitivityAnalysisParametersGroup = new Group(container, 0);
        sensitivityAnalysisParametersGroup.setText("Sensitivity Analysis Parameters");
        GridData gridDataSensitivityAnalysisParametersGroup = new GridData(4, 0x1000000, true, false);
        sensitivityAnalysisParametersGroup.setLayoutData((Object)gridDataSensitivityAnalysisParametersGroup);
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        sensitivityAnalysisParametersGroup.setLayout((Layout)gridLayout1);
        Label variableToAdaptLabel = new Label((Composite)sensitivityAnalysisParametersGroup, 0);
        GridData gridDataVariableToAdaptLabel = new GridData(131072, 0x1000000, false, false);
        variableToAdaptLabel.setLayoutData((Object)gridDataVariableToAdaptLabel);
        variableToAdaptLabel.setText("Variable:");
        this.variableText = new Text((Composite)sensitivityAnalysisParametersGroup, 2048);
        this.variableText.setEnabled(true);
        this.variableText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableText.addModifyListener(this.modifyListener);
        Button selectVariableButton = new Button((Composite)sensitivityAnalysisParametersGroup, 0);
        selectVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProtoComGenerationConfigurationTab.this.selectVariable();
            }
        });
        selectVariableButton.setText("Select Variable...");
        Composite composite = new Composite((Composite)sensitivityAnalysisParametersGroup, 0);
        GridData gdComposite = new GridData(4, 0x1000000, false, false, 3, 1);
        composite.setLayoutData((Object)gdComposite);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 6;
        composite.setLayout((Layout)gridLayout2);
        Label minimumLabel = new Label(composite, 0);
        minimumLabel.setText("Minimum:");
        this.minimumText = new Text(composite, 2048);
        this.minimumText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumText.addModifyListener(this.modifyListener);
        Label maximumLabel = new Label(composite, 0);
        maximumLabel.setText("Maximum:");
        this.maximumText = new Text(composite, 2048);
        this.maximumText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maximumText.addModifyListener(this.modifyListener);
        Label stepWidthLabel = new Label(composite, 0);
        stepWidthLabel.setText("Step Width:");
        this.stepWidthText = new Text(composite, 2048);
        this.stepWidthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stepWidthText.addModifyListener(this.modifyListener);
        Group modelTargetGroup = new Group(container, 0);
        modelTargetGroup.setText("Transformation Target");
        GridData gridDataModelTarget = new GridData(4, 0x1000000, true, false);
        modelTargetGroup.setLayoutData((Object)gridDataModelTarget);
        GridLayout gridLayoutModelTarget = new GridLayout();
        gridLayoutModelTarget.numColumns = 1;
        modelTargetGroup.setLayout((Layout)gridLayoutModelTarget);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProtoComGenerationConfigurationTab.this.setDirty(true);
                ProtoComGenerationConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.comboModelToTextTarget = new Combo((Composite)modelTargetGroup, 8);
        this.comboModelToTextTarget.setItems(new String[]{"Java SE RMI Performance Prototype", "Java SE RMI Code Stubs", "Java EE EJB Performance Prototype", "Java EE Servlet Performance Prototype"});
        this.comboModelToTextTarget.setSize(350, 50);
        this.comboModelToTextTarget.addModifyListener(modifyListener);
    }

    protected void selectVariable() {
        ResourceSetImpl rs = new ResourceSetImpl();
        ArrayList<Class<EObject>> filter = new ArrayList<Class<EObject>>();
        filter.add(EObject.class);
        for (String file : this.modelFiles) {
            try {
                rs.getResource(URI.createURI((String)file), true);
            }
            catch (Exception ex) {
                rs.getResource(URI.createFileURI((String)file), true);
            }
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(this.getShell(), filter, (Object)rs);
        if (dialog.open() == 0) {
            this.variableText.setText(EcoreUtil.getURI((EObject)dialog.getResult()).toString());
        }
    }
}

