package org.palladiosimulator.protocom.lang.java;

import java.util.Collection;

/**
 * TODO: Common IJMember for Method and Field.
 * 
 * @author Thomas Zolynski
 */
@SuppressWarnings("all")
public interface IJMethod {
  /**
   * The name of the return type of this method.
   * 
   * Default value is VOID.
   */
  String returnType();

  /**
   * The name of the method.
   */
  String name();

  /**
   * The flattened parameter list as a string.
   */
  String parameters();

  /**
   * The throw statement.
   */
  String throwsType();

  /**
   * Code of the method as a string.
   * 
   * If not set, the method will be treated as abstract.
   */
  String body();

  /**
   * The visibility modifier of this method.
   * 
   * Default value is PUBLIC.
   */
  String visibilityModifier();

  /**
   * The static modifier.
   * 
   * TODO: Move up.
   */
  String staticModifier();

  boolean isStatic();

  Collection<? extends IJAnnotation> annotations();

  String methodAnnotation();
}
