package org.palladiosimulator.protocom.tech.rmi.allocation;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.tech.rmi.PojoClass;

/**
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoAllocationStorage extends PojoClass<Allocation> {
  public PojoAllocationStorage(final Allocation pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String superClass() {
    return "org.palladiosimulator.protocom.framework.java.se.AbstractAllocationStorage";
  }

  @Override
  public String packageName() {
    return "ProtoComBootstrap";
  }

  @Override
  public String compilationUnitName() {
    return "AllocationStorage";
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    JMethod _withName = new JMethod().withName("initContainerTemplate");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("String container;");
    _builder.newLine();
    _builder.append("String containerId;");
    _builder.newLine();
    _builder.append("Class<?> component;");
    _builder.newLine();
    _builder.append("String assemblyContext;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// TODO This filters out Event Stuff. Maybe enable that in some future version.");
    _builder.newLine();
    {
      final Function1<AllocationContext, Boolean> _function = (AllocationContext i) -> {
        AssemblyContext _assemblyContext_AllocationContext = i.getAssemblyContext_AllocationContext();
        return Boolean.valueOf((!Objects.equal(_assemblyContext_AllocationContext, null)));
      };
      Iterable<AllocationContext> _filter = IterableExtensions.<AllocationContext>filter(this.pcmEntity.getAllocationContexts_Allocation(), _function);
      for(final AllocationContext context : _filter) {
        _builder.append("containerId = \"");
        String _id = context.getResourceContainer_AllocationContext().getId();
        _builder.append(_id);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("container = \"");
        String _entityName = context.getResourceContainer_AllocationContext().getEntityName();
        _builder.append(_entityName);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("component = ");
        String _fqn = JavaNames.fqn(context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext());
        _builder.append(_fqn);
        _builder.append(".class;");
        _builder.newLineIfNotEmpty();
        _builder.append("assemblyContext = \"");
        String _id_1 = context.getAssemblyContext_AllocationContext().getId();
        _builder.append(_id_1);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("saveContainerComponent(containerId, container, component, assemblyContext);");
        _builder.newLine();
      }
    }
    JMethod _withImplementation = _withName.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation));
  }

  @Override
  public String filePath() {
    return "/src/ProtoComBootstrap/AllocationStorage.java";
  }
}
