package org.palladiosimulator.protocom.tech.rmi.repository;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.rmi.PojoInterface;

/**
 * Defining the content of component implementation interfaces (the interfaces for the
 * classes implementing the component behavior).
 * 
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoComponentClassInterface extends PojoInterface<BasicComponent> {
  public PojoComponentClassInterface(final BasicComponent pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String compilationUnitName() {
    return JavaNames.interfaceName(this.pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("org.palladiosimulator.protocom.framework.java.se.IPerformancePrototypeComponent"));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      JMethod _withParameters = new JMethod().withName("setContext").withParameters("Object myContext");
      JMethod _withParameters_1 = new JMethod().withName("setComponentFrame").withParameters(PcmCommons.stackframeParameterList());
      Iterables.<JMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withParameters, _withParameters_1)));
      final Function1<ServiceEffectSpecification, JMethod> _function = (ServiceEffectSpecification it) -> {
        return new JMethod().withName(JavaNames.serviceName(it.getDescribedService__SEFF())).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList());
      };
      List<JMethod> _map = ListExtensions.<ServiceEffectSpecification, JMethod>map(this.pcmEntity.getServiceEffectSpecifications__BasicComponent(), _function);
      Iterables.<JMethod>addAll(results, _map);
      final Function1<ProvidedRole, Boolean> _function_1 = (ProvidedRole it) -> {
        return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, OperationProvidedRole> _function_2 = (ProvidedRole it) -> {
        return ((OperationProvidedRole) it);
      };
      final Function1<OperationProvidedRole, JMethod> _function_3 = (OperationProvidedRole it) -> {
        return new JMethod().withName(JavaNames.portGetter(it)).withReturnType(JavaNames.fqn(it.getProvidedInterface__OperationProvidedRole()));
      };
      Iterable<JMethod> _map_1 = IterableExtensions.<OperationProvidedRole, JMethod>map(IterableExtensions.<ProvidedRole, OperationProvidedRole>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function_1), _function_2), _function_3);
      Iterables.<JMethod>addAll(results, _map_1);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.fqnInterface(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    return (_plus + ".java");
  }
}
