package org.palladiosimulator.protocom.traverse.jsestub.repository;

import java.util.function.Consumer;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.impl.JClass;
import org.palladiosimulator.protocom.lang.java.impl.JInterface;
import org.palladiosimulator.protocom.tech.pojo.repository.PojoBasicComponentClass;
import org.palladiosimulator.protocom.tech.pojo.repository.PojoBasicComponentPortClass;
import org.palladiosimulator.protocom.tech.pojo.repository.PojoComponentClassInterface;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoBasicComponentContextClass;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoBasicComponentContextInterface;
import org.palladiosimulator.protocom.traverse.framework.repository.XBasicComponent;

/**
 * A Basic Component translates into the following Java compilation units:
 * <ul>
 * 	<li> a class implementing the component's resource demands,
 * 	<li> an interface for the component class,
 * 	<li> a context class for assembly,
 * 	<li> an interface for the context class,
 *  <li> a class for each component's port.
 * </ul>
 * 
 * @author Sebastian Lehrig
 */
@SuppressWarnings("all")
public class JseStubBasicComponent extends XBasicComponent {
  @Override
  public void generate() {
    JInterface _instance = this.injector.<JInterface>getInstance(JInterface.class);
    PojoComponentClassInterface _pojoComponentClassInterface = new PojoComponentClassInterface(this.entity);
    this.generatedFiles.add(_instance.createFor(_pojoComponentClassInterface));
    JClass _instance_1 = this.injector.<JClass>getInstance(JClass.class);
    PojoBasicComponentClass _pojoBasicComponentClass = new PojoBasicComponentClass(this.entity);
    this.generatedFiles.add(_instance_1.createFor(_pojoBasicComponentClass));
    JClass _instance_2 = this.injector.<JClass>getInstance(JClass.class);
    PojoBasicComponentContextClass _pojoBasicComponentContextClass = new PojoBasicComponentContextClass(this.entity);
    this.generatedFiles.add(_instance_2.createFor(_pojoBasicComponentContextClass));
    JInterface _instance_3 = this.injector.<JInterface>getInstance(JInterface.class);
    PojoBasicComponentContextInterface _pojoBasicComponentContextInterface = new PojoBasicComponentContextInterface(this.entity);
    this.generatedFiles.add(
      _instance_3.createFor(_pojoBasicComponentContextInterface));
    final Consumer<ProvidedRole> _function = (ProvidedRole it) -> {
      JClass _instance_4 = this.injector.<JClass>getInstance(JClass.class);
      PojoBasicComponentPortClass _pojoBasicComponentPortClass = new PojoBasicComponentPortClass(it);
      this.generatedFiles.add(_instance_4.createFor(_pojoBasicComponentPortClass));
    };
    this.entity.getProvidedRoles_InterfaceProvidingEntity().forEach(_function);
  }
}
