package org.palladiosimulator.protocom.traverse.jsestub.repository;

import java.util.function.Consumer;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.impl.JClass;
import org.palladiosimulator.protocom.lang.java.impl.JInterface;
import org.palladiosimulator.protocom.tech.pojo.repository.PojoComposedStructurePortClass;
import org.palladiosimulator.protocom.tech.pojo.repository.PojoCompositeComponentClass;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructureContextClass;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructureContextInterface;
import org.palladiosimulator.protocom.tech.rmi.repository.PojoComposedStructureInterface;
import org.palladiosimulator.protocom.traverse.framework.repository.XCompositeComponent;

/**
 * An CompositeComponent translates into the following Java compilation units:
 * <ul>
 * 	<li> a class used to setup the assembly (a CompositeComponent is a ComposedStructure),
 * 	<li> an interface for this component's class,
 * 	<li> a context class for assembly,
 * 	<li> an interface for the context class,
 *  <li> a class for each component's port. TODO: Move to traverse
 * </ul>
 * 
 * @author Sebastian Lehrig
 */
@SuppressWarnings("all")
public class JseStubCompositeComponent extends XCompositeComponent {
  @Override
  public void generate() {
    JInterface _instance = this.injector.<JInterface>getInstance(JInterface.class);
    PojoComposedStructureInterface _pojoComposedStructureInterface = new PojoComposedStructureInterface(this.entity);
    this.generatedFiles.add(_instance.createFor(_pojoComposedStructureInterface));
    JClass _instance_1 = this.injector.<JClass>getInstance(JClass.class);
    PojoCompositeComponentClass _pojoCompositeComponentClass = new PojoCompositeComponentClass(this.entity);
    this.generatedFiles.add(_instance_1.createFor(_pojoCompositeComponentClass));
    JClass _instance_2 = this.injector.<JClass>getInstance(JClass.class);
    PojoComposedStructureContextClass _pojoComposedStructureContextClass = new PojoComposedStructureContextClass(this.entity);
    this.generatedFiles.add(_instance_2.createFor(_pojoComposedStructureContextClass));
    JInterface _instance_3 = this.injector.<JInterface>getInstance(JInterface.class);
    PojoComposedStructureContextInterface _pojoComposedStructureContextInterface = new PojoComposedStructureContextInterface(this.entity);
    this.generatedFiles.add(_instance_3.createFor(_pojoComposedStructureContextInterface));
    final Consumer<ProvidedRole> _function = (ProvidedRole it) -> {
      JClass _instance_4 = this.injector.<JClass>getInstance(JClass.class);
      PojoComposedStructurePortClass _pojoComposedStructurePortClass = new PojoComposedStructurePortClass(it);
      this.generatedFiles.add(_instance_4.createFor(_pojoComposedStructurePortClass));
    };
    this.entity.getProvidedRoles_InterfaceProvidingEntity().forEach(_function);
  }
}
