/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import java.net.URI;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;
import org.palladiosimulator.protocom.framework.java.ee.modules.ContainerModule;
import org.palladiosimulator.protocom.framework.java.ee.modules.Module;
import org.palladiosimulator.protocom.framework.java.ee.modules.SystemModule;
import org.palladiosimulator.protocom.framework.java.ee.prototype.PrototypeBridge;

@Path(value="/modules")
public final class Modules {
    @Context
    private ServletContext context;
    private static LinkedList<Module> modules;

    @Inject
    private Modules(PrototypeBridge bridge) {
        if (modules == null) {
            modules = new LinkedList();
            PrototypeBridge.Container[] containerArray = bridge.getContainers();
            int n = containerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrototypeBridge.Container container = containerArray[n2];
                String id = container.getId();
                PrototypeBridge.Allocation[] allocations = bridge.getAllocations(id);
                modules.add(new ContainerModule(container, allocations));
                ++n2;
            }
            PrototypeBridge.System system = bridge.getSystem();
            modules.add(new SystemModule(system.getName(), system.getClassName()));
        }
    }

    private String getBaseUrl(UriInfo uriInfo) {
        URI uri = uriInfo.getRequestUri();
        String scheme = uri.getScheme();
        String host = uri.getHost();
        String port = String.valueOf(uri.getPort());
        return String.valueOf(scheme) + "://" + host + ":" + port + this.context.getContextPath();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getModules() {
        return Response.ok((Object)JsonHelper.toJson(modules)).build();
    }

    @GET
    @Path(value="{id}/start")
    public Response startModule(@Context UriInfo uriInfo, @PathParam(value="id") String id) {
        Module result = null;
        for (Module module : modules) {
            if (!module.getId().equals(id)) continue;
            result = module;
            break;
        }
        if (result == null) {
            return Response.status((int)404).build();
        }
        result.start(this.getBaseUrl(uriInfo));
        return Response.ok().build();
    }
}

