/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import java.io.File;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.se.strategies.DemandConsumerStrategiesRegistry;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.CalibrationTable;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.CalculatePrimesDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.CountNumbersDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.FFTDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.FibonacciDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.MandelbrotDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.SortArrayDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.VoidDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.WaitDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.hdd.ReadLargeChunksDemand;

public class AbstractResourceEnvironment {
    protected static final Logger LOGGER = Logger.getRootLogger();
    protected static final String[] CPU_STRATEGIES = new String[]{"primes", "count_numbers", "fft", "fibonacci", "mandelbrot", "sortarray", "void", "wait"};
    protected static final Class<?>[] CPU_STRATEGIES_CLASSES = new Class[]{CalculatePrimesDemand.class, CountNumbersDemand.class, FFTDemand.class, FibonacciDemand.class, MandelbrotDemand.class, SortArrayDemand.class, VoidDemand.class, WaitDemand.class};
    protected static final String[] HDD_STRATEGIES = new String[]{"largeChunks"};
    protected static final Class<?>[] HDD_STRATEGIES_CLASSES = new Class[]{ReadLargeChunksDemand.class};

    private static IDemandStrategy getStrategy(String usedStrategy, String[] strategies, Class<?>[] strategiesClasses) {
        IDemandStrategy strategy = null;
        int i = 0;
        while (i < strategies.length) {
            if (strategies[i].equals(usedStrategy)) {
                try {
                    strategy = (IDemandStrategy)strategiesClasses[i].newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.error((Object)("CPU strategy " + usedStrategy + " can not be instantiated"));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return strategy;
    }

    protected static void setUpCPU(String usedStrategy, String calibrationPath, DegreeOfAccuracyEnum accuracy, String processingRate) {
        IDemandStrategy strategy = AbstractResourceEnvironment.getStrategy(usedStrategy, CPU_STRATEGIES, CPU_STRATEGIES_CLASSES);
        if (strategy == null) {
            LOGGER.warn((Object)("CPU strategy " + (usedStrategy == null ? "" : usedStrategy) + " not found. Using Fibonacci instead"));
            strategy = new FibonacciDemand();
        }
        AbstractResourceEnvironment.registerStrategy(calibrationPath, accuracy, processingRate, strategy, ResourceTypeEnum.CPU);
    }

    protected static void setUpHDD(String usedStrategy, String calibrationPath, DegreeOfAccuracyEnum accuracy, String processingRate) {
        IDemandStrategy strategy = AbstractResourceEnvironment.getStrategy(usedStrategy, CPU_STRATEGIES, CPU_STRATEGIES_CLASSES);
        if (strategy == null) {
            LOGGER.warn((Object)("HDD strategy " + (usedStrategy == null ? "" : usedStrategy) + " not found. Using LargeChunks instead"));
            strategy = new ReadLargeChunksDemand();
        }
        AbstractResourceEnvironment.registerStrategy(calibrationPath, accuracy, processingRate, strategy, ResourceTypeEnum.HDD);
    }

    protected static String getCalibrationFileName(IDemandStrategy strategy, DegreeOfAccuracyEnum accuracy, String basePath) {
        File path;
        if (basePath == null) {
            basePath = "../ProtoComCalibration/";
        }
        if (!(path = new File(basePath)).exists()) {
            if (path.mkdirs()) {
                LOGGER.info((Object)("Created Calibration Path " + path));
            } else {
                LOGGER.error((Object)("Could not create " + path + ". Assure you have the rights to create and write to this folder."));
                System.exit(0);
            }
        }
        return String.valueOf(basePath) + "/" + strategy.getName() + "_" + 11 + "_" + accuracy.name() + ".ser";
    }

    private static void registerStrategy(String calibrationPath, DegreeOfAccuracyEnum accuracy, String processingRate, IDemandStrategy strategy, ResourceTypeEnum resourceType) {
        double procRate = (Double)StackContext.evaluateStatic((String)processingRate, Double.class);
        String fileName = AbstractResourceEnvironment.getCalibrationFileName(strategy, accuracy, calibrationPath);
        File calibrationFile = new File(fileName);
        CalibrationTable calibrationTable = CalibrationTable.load((File)calibrationFile);
        if (calibrationTable != null) {
            strategy.setCalibrationTable(calibrationTable);
        } else {
            strategy.initializeStrategy(accuracy, 0.0);
            calibrationTable = strategy.calibrate();
            calibrationTable.save(calibrationFile);
        }
        strategy.initializeStrategy(accuracy, procRate);
        DemandConsumerStrategiesRegistry.singleton().registerStrategyFor(resourceType, strategy);
    }

    public static void performDelay(double delay) {
        try {
            Thread.sleep(Math.round(delay));
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Interrupted while performing a delay", (Throwable)e);
        }
    }
}

