package org.palladiosimulator.protocom.lang.java.util;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;

/**
 * Common PCM stuff.
 * 
 * TODO: write something ingenious to justify this class here.
 */
@SuppressWarnings("all")
public class PcmCommons {
  public static String stackframeType() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>");
    return _builder.toString();
  }

  public static String stackframeParameterList() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> myComponentStackFrame");
    return _builder.toString();
  }

  public static String stackContextParameterList() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.StackContext ctx");
    return _builder.toString();
  }

  public static String stackContextClass() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.StackContext");
    return _builder.toString();
  }

  public static String stackContextParameterUsageList() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ctx");
    return _builder.toString();
  }

  public static String call(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages, final List<VariableUsage> outParameterUsages) {
    String _javaSignature = JavaNames.javaSignature(signature);
    String _plus = (prefix + _javaSignature);
    String _plus_1 = (_plus + "(");
    String _plus_2 = (_plus_1 + "ctx");
    return (_plus_2 + ");");
  }

  public static String callStub(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages, final List<VariableUsage> outParameterUsages) {
    String _javaName = JavaNames.javaName(signature);
    String _plus = (prefix + _javaName);
    String _plus_1 = (_plus + "(");
    String _parameterUsageList = Parameters.getParameterUsageList(signature);
    String _plus_2 = (_plus_1 + _parameterUsageList);
    return (_plus_2 + ");");
  }

  public static ProvidedDelegationConnector getProvidedDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    final Function1<Connector, Boolean> _function = (Connector it) -> {
      return Boolean.valueOf(ProvidedDelegationConnector.class.isInstance(it));
    };
    final Function1<Connector, Boolean> _function_1 = (Connector it) -> {
      OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = ((ProvidedDelegationConnector) it).getOuterProvidedRole_ProvidedDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
    };
    Connector _get = IterableExtensions.<Connector>toList(IterableExtensions.<Connector>filter(IterableExtensions.<Connector>filter(s.getConnectors__ComposedStructure(), _function), _function_1)).get(0);
    return ((ProvidedDelegationConnector) _get);
  }

  public static List<Connector> getProvidedDelegationConnector(final ComposedStructure s) {
    final Function1<Connector, Boolean> _function = (Connector it) -> {
      return Boolean.valueOf(ProvidedDelegationConnector.class.isInstance(it));
    };
    List<Connector> _list = IterableExtensions.<Connector>toList(IterableExtensions.<Connector>filter(s.getConnectors__ComposedStructure(), _function));
    return ((List<Connector>) _list);
  }

  public static RequiredDelegationConnector getRequiredDelegationConnector(final ComposedStructure s, final RequiredRole p) {
    final Function1<Connector, Boolean> _function = (Connector it) -> {
      return Boolean.valueOf(RequiredDelegationConnector.class.isInstance(it));
    };
    final Function1<Connector, Boolean> _function_1 = (Connector it) -> {
      OperationRequiredRole _outerRequiredRole_RequiredDelegationConnector = ((RequiredDelegationConnector) it).getOuterRequiredRole_RequiredDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerRequiredRole_RequiredDelegationConnector, p));
    };
    Connector _get = IterableExtensions.<Connector>toList(IterableExtensions.<Connector>filter(IterableExtensions.<Connector>filter(s.getConnectors__ComposedStructure(), _function), _function_1)).get(0);
    return ((RequiredDelegationConnector) _get);
  }

  public static List<Connector> getRequiredDelegationConnector(final ComposedStructure s) {
    final Function1<Connector, Boolean> _function = (Connector it) -> {
      return Boolean.valueOf(RequiredDelegationConnector.class.isInstance(it));
    };
    List<Connector> _list = IterableExtensions.<Connector>toList(IterableExtensions.<Connector>filter(s.getConnectors__ComposedStructure(), _function));
    return ((List<Connector>) _list);
  }

  public static boolean hasConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<Connector, Boolean> _function = (Connector con) -> {
      return Boolean.valueOf(PcmCalls.test(con, ctx, r));
    };
    int _size = IterableExtensions.size(IterableExtensions.<Connector>filter(PcmCalls.connectors(s), _function));
    return (_size == 1);
  }

  public static Connector getConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<Connector, Boolean> _function = (Connector con) -> {
      return Boolean.valueOf(PcmCalls.test(con, ctx, r));
    };
    return ((Connector[])Conversions.unwrapArray(IterableExtensions.<Connector>filter(PcmCalls.connectors(s), _function), Connector.class))[0];
  }
}
