package org.palladiosimulator.protocom.model.seff;

import java.util.List;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;

/**
 * @author Christian Klaussner
 */
@SuppressWarnings("all")
public class BranchActionAdapter extends ActionAdapter<BranchAction> {
  public BranchActionAdapter(final BranchAction entity) {
    super(entity);
  }

  public List<BranchTransitionAdapter<? extends AbstractBranchTransition>> getBranchTransitions() {
    final Function1<AbstractBranchTransition, BranchTransitionAdapter<? extends AbstractBranchTransition>> _function = (AbstractBranchTransition it) -> {
      BranchTransitionAdapter<? extends AbstractBranchTransition> _switchResult = null;
      boolean _matched = false;
      if (it instanceof ProbabilisticBranchTransition) {
        _matched=true;
        _switchResult = new ProbabilisticBranchTransitionAdapter(((ProbabilisticBranchTransition)it));
      }
      if (!_matched) {
        if (it instanceof GuardedBranchTransition) {
          _matched=true;
          _switchResult = new GuardedBranchTransitionAdapter(((GuardedBranchTransition)it));
        }
      }
      return _switchResult;
    };
    return ListExtensions.<AbstractBranchTransition, BranchTransitionAdapter<? extends AbstractBranchTransition>>map(this.entity.getBranches_Branch(), _function);
  }
}
