/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.markov.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.reliability.markov.provider.EntityItemProvider;
import org.palladiosimulator.reliability.markov.provider.LabelItemProvider;
import org.palladiosimulator.reliability.markov.provider.MarkovChainItemProvider;
import org.palladiosimulator.reliability.markov.provider.StateItemProvider;
import org.palladiosimulator.reliability.markov.provider.TransitionItemProvider;
import org.palladiosimulator.reliability.markov.util.MarkovAdapterFactory;

public class MarkovItemProviderAdapterFactory
extends MarkovAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected StateItemProvider stateItemProvider;
    protected TransitionItemProvider transitionItemProvider;
    protected MarkovChainItemProvider markovChainItemProvider;
    protected EntityItemProvider entityItemProvider;
    protected LabelItemProvider labelItemProvider;

    public MarkovItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createStateAdapter() {
        if (this.stateItemProvider == null) {
            this.stateItemProvider = new StateItemProvider((AdapterFactory)this);
        }
        return this.stateItemProvider;
    }

    public Adapter createTransitionAdapter() {
        if (this.transitionItemProvider == null) {
            this.transitionItemProvider = new TransitionItemProvider((AdapterFactory)this);
        }
        return this.transitionItemProvider;
    }

    public Adapter createMarkovChainAdapter() {
        if (this.markovChainItemProvider == null) {
            this.markovChainItemProvider = new MarkovChainItemProvider((AdapterFactory)this);
        }
        return this.markovChainItemProvider;
    }

    public Adapter createEntityAdapter() {
        if (this.entityItemProvider == null) {
            this.entityItemProvider = new EntityItemProvider((AdapterFactory)this);
        }
        return this.entityItemProvider;
    }

    public Adapter createLabelAdapter() {
        if (this.labelItemProvider == null) {
            this.labelItemProvider = new LabelItemProvider((AdapterFactory)this);
        }
        return this.labelItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.stateItemProvider != null) {
            this.stateItemProvider.dispose();
        }
        if (this.transitionItemProvider != null) {
            this.transitionItemProvider.dispose();
        }
        if (this.markovChainItemProvider != null) {
            this.markovChainItemProvider.dispose();
        }
        if (this.entityItemProvider != null) {
            this.entityItemProvider.dispose();
        }
        if (this.labelItemProvider != null) {
            this.labelItemProvider.dispose();
        }
    }
}

