/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;

public class ComponentSensitivity
extends MarkovSensitivity {
    private List<Double> baseValues = null;
    private String componentId = null;
    private String componentName = null;
    private List<InternalFailureOccurrenceDescription> descriptions = null;

    public ComponentSensitivity(String name, String componentId, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
        this.componentId = componentId;
    }

    @Override
    protected boolean alterModel() {
        int i = 0;
        while (i < this.descriptions.size()) {
            this.descriptions.get(i).setFailureProbability(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValues.get(i)));
            ++i;
        }
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        this.descriptions = new BasicEList();
        this.baseValues = new ArrayList<Double>();
        List<InternalAction> internalActions = this.getInternalActions();
        if (internalActions == null) {
            LOGGER.error((Object)("Did not find any InternalActions for BasicComponent \"" + this.componentName + "\" <ID=" + this.componentId + ">"));
            return;
        }
        for (InternalAction action : internalActions) {
            for (InternalFailureOccurrenceDescription description : action.getInternalFailureOccurrenceDescriptions__InternalAction()) {
                this.descriptions.add(description);
                this.baseValues.add(description.getFailureProbability());
            }
        }
    }

    private BasicComponent getBasicComponent() {
        List repositories = this.getModel().getRepositories();
        if (repositories.size() == 0) {
            LOGGER.error((Object)"No PCM Repositories found.");
            return null;
        }
        for (Repository repository : repositories) {
            EList components = this.helper.getElements((EObject)repository, RepositoryFactory.eINSTANCE.createBasicComponent().eClass());
            for (EObject object : components) {
                if (!((BasicComponent)object).getId().equals(this.componentId)) continue;
                this.componentName = ((BasicComponent)object).getEntityName();
                return (BasicComponent)object;
            }
        }
        LOGGER.error((Object)("BasicComponent \"" + this.componentName + "\" <ID=" + this.componentId + "> not found."));
        return null;
    }

    private List<InternalAction> getInternalActions() {
        BasicComponent component = this.getBasicComponent();
        if (component == null) {
            return null;
        }
        BasicEList resultList = new BasicEList();
        for (ServiceEffectSpecification specifiction : component.getServiceEffectSpecifications__BasicComponent()) {
            if (!(specifiction instanceof ResourceDemandingSEFF)) continue;
            resultList.addAll(this.getInternalActionsForBehaviour((ResourceDemandingBehaviour)((ResourceDemandingSEFF)specifiction)));
        }
        return resultList;
    }

    private List<InternalAction> getInternalActionsForBehaviour(ResourceDemandingBehaviour behaviour) {
        BasicEList resultList = new BasicEList();
        for (AbstractAction action : behaviour.getSteps_Behaviour()) {
            if (action instanceof InternalAction) {
                resultList.add((InternalAction)action);
                continue;
            }
            if (action instanceof AbstractLoopAction) {
                resultList.addAll(this.getInternalActionsForBehaviour(((AbstractLoopAction)action).getBodyBehaviour_Loop()));
                continue;
            }
            if (action instanceof BranchAction) {
                for (AbstractBranchTransition transition : ((BranchAction)action).getBranches_Branch()) {
                    resultList.addAll(this.getInternalActionsForBehaviour(transition.getBranchBehaviour_BranchTransition()));
                }
                continue;
            }
            if (action instanceof RecoveryAction) {
                for (RecoveryActionBehaviour recoveryBehaviour : ((RecoveryAction)action).getRecoveryActionBehaviours__RecoveryAction()) {
                    resultList.addAll(this.getInternalActionsForBehaviour((ResourceDemandingBehaviour)recoveryBehaviour));
                }
                continue;
            }
            if (!(action instanceof ForkAction)) continue;
            if (((ForkAction)action).getAsynchronousForkedBehaviours_ForkAction() != null) {
                for (ForkedBehaviour forkedBehaviour : ((ForkAction)action).getAsynchronousForkedBehaviours_ForkAction()) {
                    resultList.addAll(this.getInternalActionsForBehaviour((ResourceDemandingBehaviour)forkedBehaviour));
                }
            }
            if (((ForkAction)action).getSynchronisingBehaviours_ForkAction() == null) continue;
            for (ForkedBehaviour forkedBehaviour : ((ForkAction)action).getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint()) {
                resultList.addAll(this.getInternalActionsForBehaviour((ResourceDemandingBehaviour)forkedBehaviour));
            }
        }
        return resultList;
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Component Name");
        headings.add("Component ID");
        headings.add("Failure Probability");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.componentName);
        resultList.add(this.componentId);
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

