/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;

public class MTTFSensitivity
extends MarkovSensitivity {
    List<Double> baseValues = null;
    List<ProcessingResourceSpecification> specifications = null;

    public MTTFSensitivity(String name, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
    }

    @Override
    protected boolean alterModel() {
        int i = 0;
        while (i < this.specifications.size()) {
            this.specifications.get(i).setMTTF(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValues.get(i)));
            ++i;
        }
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        this.specifications = new BasicEList();
        this.baseValues = new ArrayList<Double>();
        if (this.getModel().getResourceEnvironment() == null) {
            LOGGER.error((Object)"No PCM ResourceEnvironment found.");
            return;
        }
        ResourceContainer resourceContainer = null;
        EList resourceContainers = this.helper.getElements((EObject)this.getModel().getResourceEnvironment(), ResourceenvironmentFactory.eINSTANCE.createResourceContainer().eClass());
        for (EObject object : resourceContainers) {
            resourceContainer = (ResourceContainer)object;
            for (ProcessingResourceSpecification specification : resourceContainer.getActiveResourceSpecifications_ResourceContainer()) {
                this.specifications.add(specification);
                this.baseValues.add(specification.getMTTF());
            }
        }
        if (this.specifications.size() == 0) {
            LOGGER.error((Object)"Did not find any ProcessingResourceSpecifications in the PCM ResourceEnvironment");
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Mean Time To Failure");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

