/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class MultiSensitivity
extends MarkovSensitivity {
    private boolean isCombinatory;
    public List<MarkovSensitivity> sensitivityParameters;

    public MultiSensitivity(String name, List<MarkovSensitivity> sensitivityParameters, boolean isCombinatory) {
        super(name, null);
        this.sensitivityParameters = sensitivityParameters;
        this.isCombinatory = isCombinatory;
        this.determineNumberOfSteps();
    }

    @Override
    protected boolean alterModel() {
        boolean modelAltered = false;
        if (!this.isCombinatory) {
            for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
                if (!sensitivity.alterModel()) continue;
                modelAltered = true;
            }
        }
        if (this.isCombinatory && this.sensitivityParameters.size() > 0) {
            for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
                if (!sensitivity.alterModel()) continue;
                modelAltered = true;
            }
        }
        return modelAltered;
    }

    private void determineNumberOfSteps() {
        this.numberOfSteps = this.isCombinatory ? 1 : 0;
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            if (!this.isCombinatory) {
                if (sensitivity.numberOfSteps <= this.numberOfSteps) continue;
                this.numberOfSteps = sensitivity.numberOfSteps;
                continue;
            }
            this.numberOfSteps *= sensitivity.numberOfSteps;
        }
    }

    @Override
    protected void extractSensitivityInformation() {
    }

    @Override
    protected int getCurrentStepNumber() {
        if (this.isCombinatory) {
            int stepNumber = 1;
            int i = 0;
            while (i < this.sensitivityParameters.size()) {
                int step = this.sensitivityParameters.get(i).getCurrentStepNumber();
                if (step == 0) {
                    return 0;
                }
                int weight = 1;
                int j = i + 1;
                while (j < this.sensitivityParameters.size()) {
                    weight *= this.sensitivityParameters.get((int)j).numberOfSteps;
                    ++j;
                }
                stepNumber += weight * (step - 1);
                ++i;
            }
            return stepNumber;
        }
        int stepNumber = 0;
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            stepNumber = Math.max(stepNumber, sensitivity.getCurrentStepNumber());
        }
        return stepNumber;
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> newHeadings = new ArrayList<String>();
        ArrayList<List<List<String>>> existingHeadings = new ArrayList<List<List<String>>>();
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            existingHeadings.add(sensitivity.getLogHeadingsMulti());
        }
        resultList.add(newHeadings);
        int i = 0;
        while (i < this.getMaxNumberOfLines(existingHeadings)) {
            resultList.add(new ArrayList());
            ++i;
        }
        i = 0;
        while (i < existingHeadings.size()) {
            int numberOfColums = 0;
            int j = 0;
            while (j < existingHeadings.get(i).size()) {
                numberOfColums = existingHeadings.get(i).get(j).size();
                int resultIndex = resultList.size() - existingHeadings.get(i).size() + j;
                ((List)resultList.get(resultIndex)).addAll((Collection)existingHeadings.get(i).get(j));
                ++j;
            }
            newHeadings.add(this.sensitivityParameters.get((int)i).name);
            j = 0;
            while (j < resultList.size() - existingHeadings.get(i).size()) {
                int k = j == 0 ? 1 : 0;
                while (k < numberOfColums) {
                    ((List)resultList.get(j)).add("");
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            resultList.addAll(sensitivity.getLogSingleResultsMulti());
        }
        return resultList;
    }

    private int getMaxNumberOfLines(ArrayList<List<List<String>>> logHeadingsList) {
        int maxNumberOfLines = 0;
        int i = 0;
        while (i < logHeadingsList.size()) {
            int numberOfLines = logHeadingsList.get(i).size();
            maxNumberOfLines = Math.max(numberOfLines, maxNumberOfLines);
            ++i;
        }
        return maxNumberOfLines;
    }

    private int getStepCount(int index) {
        MarkovSensitivity sensitivity = this.sensitivityParameters.get(index);
        return sensitivity.getCurrentStepNumber();
    }

    @Override
    protected boolean increaseCurrentStepNumber() {
        if (this.isCombinatory) {
            if (this.sensitivityParameters.size() > 0) {
                return this.increaseStepCountRecursively(0);
            }
            return true;
        }
        boolean overflow = true;
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            if (sensitivity.increaseCurrentStepNumber()) continue;
            overflow = false;
        }
        return overflow;
    }

    private boolean increaseStepCount(int index) {
        MarkovSensitivity sensitivity = this.sensitivityParameters.get(index);
        if (!sensitivity.increaseCurrentStepNumber()) {
            int i = index + 1;
            while (i < this.sensitivityParameters.size()) {
                this.sensitivityParameters.get(i).resetCurrentStepNumber();
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean increaseStepCountRecursively(int index) {
        if (this.getStepCount(index) == 0) {
            this.initStepCountRecusively(index);
            return false;
        }
        if (this.sensitivityParameters.size() > index + 1) {
            if (this.increaseStepCountRecursively(index + 1)) {
                return this.increaseStepCount(index);
            }
            return false;
        }
        return this.increaseStepCount(index);
    }

    private void initStepCountRecusively(int index) {
        if (this.sensitivityParameters.size() > index) {
            MarkovSensitivity sensitivity = this.sensitivityParameters.get(index);
            sensitivity.resetCurrentStepNumber();
            this.initStepCountRecusively(index + 1);
        }
    }

    @Override
    protected void resetCurrentStepNumber() {
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            sensitivity.resetCurrentStepNumber();
        }
    }

    @Override
    protected void setModel(PCMInstance model) {
        super.setModel(model);
        for (MarkovSensitivity sensitivity : this.sensitivityParameters) {
            sensitivity.setModel(model);
        }
    }
}

