/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.pcm2markov;

import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.reliability.markov.State;
import org.palladiosimulator.reliability.markov.StateType;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovBuilder;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovSeffVisitor;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovTransformationSource;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.utils.ManagedPMFParser;
import org.palladiosimulator.solver.core.visitors.EMFQueryHelper;

public class MarkovUsageModelVisitor
extends UsagemodelSwitch<MarkovChain> {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovUsageModelVisitor.class.getName());
    private ContextWrapper contextWrapper = null;
    private final MarkovEvaluationType evaluationType;
    private final MarkovBuilder markovBuilder;
    private final boolean optimize;
    private final List<String> prefixes;
    private final boolean recordTraces;
    private final boolean simplifiedStateHandling;
    private final MarkovTransformationSource transformationState;

    public MarkovUsageModelVisitor(MarkovTransformationSource transformationState, MarkovEvaluationType evaluationType, boolean simplifiedStateHandling, boolean optimize, boolean recordTraces) {
        this.evaluationType = evaluationType;
        this.transformationState = transformationState;
        this.simplifiedStateHandling = simplifiedStateHandling;
        this.optimize = optimize;
        this.recordTraces = recordTraces;
        this.prefixes = new ArrayList<String>();
        this.markovBuilder = new MarkovBuilder(recordTraces);
    }

    public MarkovChain caseBranch(Branch branch) {
        String name = String.valueOf(branch.getEntityName()) + "[" + branch.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit Branch: " + name));
        ArrayList<MarkovChain> specificMarkovChains = new ArrayList<MarkovChain>();
        ArrayList<Double> branchProbabilities = new ArrayList<Double>();
        EList transitions = branch.getBranchTransitions_Branch();
        int i = 0;
        while (i < transitions.size()) {
            if (!(((BranchTransition)transitions.get(i)).getBranchProbability() <= 0.0)) {
                branchProbabilities.add(((BranchTransition)transitions.get(i)).getBranchProbability());
                specificMarkovChains.add((MarkovChain)this.doSwitch((EObject)((BranchTransition)transitions.get(i)).getBranchedBehaviour_BranchTransition()));
            }
            ++i;
        }
        MarkovChain aggregateMarkovChain = this.markovBuilder.initBranchMarkovChain(this.prefixes, branchProbabilities);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i2 = 0;
        while (i2 < aggregateMarkovChain.getStates().size()) {
            if (((State)aggregateMarkovChain.getStates().get(i2)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)aggregateMarkovChain.getStates().get(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, (MarkovChain)specificMarkovChains.get(i2), (State)statesToReplace.get(i2), this.optimize, false);
            ++i2;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    public MarkovChain caseDelay(Delay delay) {
        String name = String.valueOf(delay.getEntityName()) + "[" + delay.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit Delay: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseEntryLevelSystemCall(EntryLevelSystemCall call) {
        String name = String.valueOf(call.getEntityName()) + "[" + call.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit EntryLevelSystemCall: " + name));
        List contextWrapperList = this.contextWrapper == null ? ContextWrapper.getContextWrapperFor((EntryLevelSystemCall)call, (PCMInstance)this.transformationState.getModel()) : this.contextWrapper.getContextWrapperFor(call);
        if (contextWrapperList.size() > 1) {
            LOGGER.error((Object)("The Reliability solver only supports one AllocationContext per AssemblyContext. Picking one of the called Allocation contexts for call " + call.getEntityName() + " " + call.getId() + " ignoring the others. Results will be inaccurate."));
        } else if (contextWrapperList.size() == 0) {
            throw new RuntimeException("Internal Error: Could not create a Context Wrapper for call " + call.getEntityName() + " " + call.getId());
        }
        this.contextWrapper = (ContextWrapper)contextWrapperList.get(0);
        ServiceEffectSpecification seff = this.contextWrapper.getNextSEFF(call);
        MarkovChain resultChain = null;
        if (seff != null) {
            MarkovSeffVisitor seffVisitor = new MarkovSeffVisitor(this.transformationState, this.contextWrapper, this.prefixes, this.evaluationType, this.simplifiedStateHandling, this.optimize, this.recordTraces);
            resultChain = (MarkovChain)seffVisitor.doSwitch((EObject)seff);
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseLoop(Loop loop) {
        ManagedPMF pmf;
        String name = String.valueOf(loop.getEntityName()) + "[" + loop.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit Loop: " + name));
        String specification = loop.getLoopIteration_Loop().getSpecification();
        try {
            pmf = ManagedPMFParser.createFromString((String)specification);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not create a ManagedPMF from string \"" + specification + "\""));
            return null;
        }
        ArrayList<String> prefixesCopy = new ArrayList<String>();
        prefixesCopy.addAll(this.prefixes);
        this.prefixes.clear();
        MarkovChain specificMarkovChain = (MarkovChain)this.doSwitch((EObject)loop.getBodyBehaviour_Loop());
        this.prefixes.addAll(prefixesCopy);
        MarkovChain aggregateMarkovChain = this.markovBuilder.initLoopMarkovChain(this.prefixes, pmf);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i = 0;
        while (i < aggregateMarkovChain.getStates().size()) {
            if (((State)aggregateMarkovChain.getStates().get(i)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)aggregateMarkovChain.getStates().get(i));
            }
            ++i;
        }
        i = 0;
        while (i < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, specificMarkovChain, (State)statesToReplace.get(i), this.optimize, true);
            ++i;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    public MarkovChain caseScenarioBehaviour(ScenarioBehaviour scenarioBehaviour) {
        String name = String.valueOf(scenarioBehaviour.getEntityName()) + "[" + scenarioBehaviour.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit Scenario Behaviour: " + name));
        ArrayList<Start> actions = new ArrayList<Start>();
        ArrayList<String> actionNames = new ArrayList<String>();
        ArrayList<MarkovChain> chains = new ArrayList<MarkovChain>();
        Start action = (Start)EMFQueryHelper.getObjectByType((EList)scenarioBehaviour.getActions_ScenarioBehaviour(), Start.class);
        while (action != null) {
            actions.add(action);
            actionNames.add(String.valueOf(action.getEntityName()) + "[" + action.getId() + "]");
            MarkovChain specificMarkovChain = (MarkovChain)this.doSwitch((EObject)action);
            chains.add(specificMarkovChain);
            action = action.getSuccessor();
        }
        ArrayList<State> states = new ArrayList<State>();
        MarkovChain aggregateMarkovChain = this.markovBuilder.initSequentialMarkovChain(this.prefixes, actionNames, states);
        int i = 0;
        while (i < actions.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, (MarkovChain)chains.get(i), states.get(i), this.optimize, false);
            ++i;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    public MarkovChain caseStart(Start start) {
        String name = String.valueOf(start.getEntityName()) + "[" + start.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit Start: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseStop(Stop stop) {
        String name = String.valueOf(stop.getEntityName()) + "[" + stop.getId() + "]";
        LOGGER.debug((Object)("Visit Stop: " + name));
        this.prefixes.add(name);
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }
}

