/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.reporting;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.reliability.solver.reporting.MarkovReportingTable;

public class MarkovReportItem {
    private List<MarkovReportingTable> failureModeTables;
    private List<MarkovReportingTable> impactAnalysisTables;
    private String scenarioId;
    private String scenarioName;
    private String successProbabilityAsString;

    public MarkovReportItem(String scenarioName, String scenarioId, String successProbabilityAsString) {
        this.scenarioName = scenarioName;
        this.scenarioId = scenarioId;
        this.successProbabilityAsString = successProbabilityAsString;
        this.failureModeTables = new ArrayList<MarkovReportingTable>();
        this.impactAnalysisTables = new ArrayList<MarkovReportingTable>();
    }

    public void addFailureModeTable(MarkovReportingTable failureModeTable) {
        this.failureModeTables.add(failureModeTable);
    }

    public void addImpactAnalysisTable(MarkovReportingTable impactAnalysisTable) {
        this.impactAnalysisTables.add(impactAnalysisTable);
    }

    public List<MarkovReportingTable> getFailureModeTables() {
        return this.failureModeTables;
    }

    public List<MarkovReportingTable> getImpactAnalysisTables() {
        return this.impactAnalysisTables;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public String getSuccessProbabilityString() {
        return this.successProbabilityAsString;
    }

    public void setScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }
}

