/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.runconfig;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.reliability.MarkovEvaluationType;

public class OptionsTab
extends AbstractLaunchConfigurationTab {
    private static final String FILENAME_TAB_IMAGE_PATH = "icons/options_tab.gif";
    private static final boolean ITERATION_OVER_PHYSICAL_SYSTEM_STATES_ENABLED = true;
    private static final String LOGFILEDEFAULT = "";
    private static final MarkovEvaluationType MARKOV_EVALUATION_MODE = MarkovEvaluationType.POINTSOFFAILURE;
    private static final boolean MARKOV_MODEL_REDUCTION_ENABLED = true;
    private static final boolean MARKOV_MODEL_STORAGE_ENABLED = false;
    private static final boolean MARKOV_MODEL_TRACES_ENABLED = false;
    private static final String MARKOVMODELFILEDEFAULT = "";
    private static final int NUMBER_OF_EVALUATED_SYSTEM_STATES = 1;
    private static final boolean NUMBER_OF_EVALUATED_SYSTEM_STATES_ENABLED = false;
    private static final int NUMBER_OF_EXACT_DECIMAL_PLACES = 1;
    private static final boolean NUMBER_OF_EXACT_DECIMAL_PLACES_ENABLED = false;
    private static final String PLUGIN_ID = "org.palladiosimulator.reliability.solver";
    private static final String SAVE_FILE_DEFAULT = "";
    private static final boolean SAVE_RESULTS_TO_FILE_ENABLED = false;
    private static final boolean SINGLERESULTSDEFAULT = false;
    private static final int SOLVING_TIME_LIMIT = 1;
    private static final boolean SOLVING_TIME_LIMIT_ENABLED = false;
    private static final boolean STATISTICSDEFAULT = false;
    private Button buttonFileSystemFileDialogLogFile = null;
    private Button buttonFileSystemFileDialogModelFile = null;
    private Button buttonFileSystemFileDialogSaveToFile = null;
    private Button buttonWorkspaceFileDialogLogFile = null;
    private Button buttonWorkspaceFileDialogModelFile = null;
    private Button buttonWorkspaceFileDialogSaveToFile = null;
    private Button checkIterateOverPhysicalSystemStates;
    private Button checkMarkovModelTraces = null;
    private Button checkMarkovStatistics = null;
    private Button checkNumberOfEvaluatedSystemStates = null;
    private Button checkNumberOfExactDecimalPlaces = null;
    private Button checkOptimize = null;
    private Button checkSaveResultsToFile = null;
    private Button checkSingleResults = null;
    private Button checkSolvingTimeLimit = null;
    private Button checkStoreMarkovModel = null;
    private Button radioFailureCategories = null;
    private Button radioFailureTypes = null;
    private Button radioPointsOfFailure = null;
    private Button radioSingleFailureMode = null;
    private Spinner spinnerNumberOfEvaluatedSystemStates = null;
    private Spinner spinnerNumberOfExactDecimalPlaces = null;
    private Spinner spinnerSolvingTimeLimit = null;
    private Text textLogFile = null;
    private Text textMarkovModelFile = null;
    private Text textSaveResultsToFile = null;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void createControl(Composite parent) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                OptionsTab.this.setDirty(true);
                OptionsTab.this.updateLaunchConfigurationDialog();
                OptionsTab.this.updateFieldsEnablement();
            }
        };
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OptionsTab.this.setDirty(true);
                OptionsTab.this.updateLaunchConfigurationDialog();
                OptionsTab.this.updateFieldsEnablement();
            }
        };
        ScrolledComposite container = new ScrolledComposite(parent, 768);
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        Composite contentContainer = new Composite((Composite)container, 0);
        container.setContent((Control)contentContainer);
        GridLayout layout = new GridLayout();
        contentContainer.setLayout((Layout)layout);
        this.setControl((Control)container);
        GridLayout stopConditionsLayout = new GridLayout();
        stopConditionsLayout.numColumns = 2;
        Group stopConditionsGroup = new Group(contentContainer, 0);
        stopConditionsGroup.setLayout((Layout)stopConditionsLayout);
        stopConditionsGroup.setText("Stop Conditions");
        stopConditionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkNumberOfEvaluatedSystemStates = new Button((Composite)stopConditionsGroup, 32);
        this.checkNumberOfEvaluatedSystemStates.setText("Number of evaluated system states:");
        this.checkNumberOfEvaluatedSystemStates.setSelection(false);
        this.checkNumberOfEvaluatedSystemStates.addListener(13, listener);
        this.checkNumberOfEvaluatedSystemStates.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerNumberOfEvaluatedSystemStates = new Spinner((Composite)stopConditionsGroup, 0);
        this.spinnerNumberOfEvaluatedSystemStates.setIncrement(1);
        this.spinnerNumberOfEvaluatedSystemStates.setMinimum(1);
        this.spinnerNumberOfEvaluatedSystemStates.setMaximum(1000000);
        this.spinnerNumberOfEvaluatedSystemStates.setSelection(1);
        this.spinnerNumberOfEvaluatedSystemStates.setEnabled(false);
        this.spinnerNumberOfEvaluatedSystemStates.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerNumberOfEvaluatedSystemStates.addListener(13, listener);
        this.spinnerNumberOfEvaluatedSystemStates.addModifyListener(modifyListener);
        this.checkNumberOfExactDecimalPlaces = new Button((Composite)stopConditionsGroup, 32);
        this.checkNumberOfExactDecimalPlaces.setText("Number of exact decimal places:");
        this.checkNumberOfExactDecimalPlaces.setSelection(false);
        this.checkNumberOfExactDecimalPlaces.addListener(13, listener);
        this.checkNumberOfExactDecimalPlaces.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerNumberOfExactDecimalPlaces = new Spinner((Composite)stopConditionsGroup, 0);
        this.spinnerNumberOfExactDecimalPlaces.setIncrement(1);
        this.spinnerNumberOfExactDecimalPlaces.setMinimum(1);
        this.spinnerNumberOfExactDecimalPlaces.setMaximum(10);
        this.spinnerNumberOfExactDecimalPlaces.setSelection(1);
        this.spinnerNumberOfExactDecimalPlaces.setEnabled(false);
        this.spinnerNumberOfExactDecimalPlaces.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerNumberOfExactDecimalPlaces.addListener(13, listener);
        this.spinnerNumberOfExactDecimalPlaces.addModifyListener(modifyListener);
        this.checkSolvingTimeLimit = new Button((Composite)stopConditionsGroup, 32);
        this.checkSolvingTimeLimit.setText("Solving time (in seconds):");
        this.checkSolvingTimeLimit.setSelection(false);
        this.checkSolvingTimeLimit.addListener(13, listener);
        this.checkSolvingTimeLimit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerSolvingTimeLimit = new Spinner((Composite)stopConditionsGroup, 0);
        this.spinnerSolvingTimeLimit.setIncrement(1);
        this.spinnerSolvingTimeLimit.setMinimum(1);
        this.spinnerSolvingTimeLimit.setMaximum(86400);
        this.spinnerSolvingTimeLimit.setSelection(1);
        this.spinnerSolvingTimeLimit.setEnabled(false);
        this.spinnerSolvingTimeLimit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerSolvingTimeLimit.addListener(13, listener);
        this.spinnerSolvingTimeLimit.addModifyListener(modifyListener);
        GridLayout markovTransformationLayout = new GridLayout();
        markovTransformationLayout.numColumns = 4;
        Group markovTransformationGroup = new Group(contentContainer, 0);
        markovTransformationGroup.setLayout((Layout)markovTransformationLayout);
        markovTransformationGroup.setText("Markov Transformation");
        markovTransformationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkOptimize = new Button((Composite)markovTransformationGroup, 32);
        this.checkOptimize.setLayoutData((Object)new GridData(4, 0x1000000, false, false, markovTransformationLayout.numColumns, 1));
        this.checkOptimize.setText("Apply Markov model reduction");
        this.checkOptimize.setSelection(true);
        this.checkOptimize.addListener(13, listener);
        this.checkMarkovModelTraces = new Button((Composite)markovTransformationGroup, 32);
        this.checkMarkovModelTraces.setLayoutData((Object)new GridData(4, 0x1000000, false, false, markovTransformationLayout.numColumns, 1));
        this.checkMarkovModelTraces.setText("Add Markov traces");
        this.checkMarkovModelTraces.setSelection(false);
        this.checkMarkovModelTraces.addListener(13, listener);
        this.checkIterateOverPhysicalSystemStates = new Button((Composite)markovTransformationGroup, 32);
        this.checkIterateOverPhysicalSystemStates.setLayoutData((Object)new GridData(4, 0x1000000, false, false, markovTransformationLayout.numColumns, 1));
        this.checkIterateOverPhysicalSystemStates.setText("Iterate over physical system states");
        this.checkIterateOverPhysicalSystemStates.setSelection(true);
        this.checkIterateOverPhysicalSystemStates.addListener(13, listener);
        this.checkStoreMarkovModel = new Button((Composite)markovTransformationGroup, 32);
        this.checkStoreMarkovModel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, markovTransformationLayout.numColumns, 1));
        this.checkStoreMarkovModel.setText("Store Markov model");
        this.checkStoreMarkovModel.setSelection(false);
        this.checkStoreMarkovModel.addListener(13, listener);
        Label labelModelFile = new Label((Composite)markovTransformationGroup, 0);
        labelModelFile.setText("Model file:");
        this.textMarkovModelFile = new Text((Composite)markovTransformationGroup, 2048);
        this.textMarkovModelFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textMarkovModelFile.setEnabled(false);
        this.textMarkovModelFile.setText("");
        this.textMarkovModelFile.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                OptionsTab.this.setDirty(true);
                OptionsTab.this.updateLaunchConfigurationDialog();
                OptionsTab.this.updateFieldsEnablement();
            }
        });
        this.buttonWorkspaceFileDialogModelFile = new Button((Composite)markovTransformationGroup, 0);
        this.buttonWorkspaceFileDialogModelFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonWorkspaceFileDialogModelFile.setText("Workspace...");
        this.buttonWorkspaceFileDialogModelFile.setEnabled(false);
        this.buttonWorkspaceFileDialogModelFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String newModelFile;
                IFile file = WorkspaceResourceDialog.openNewFile((Shell)OptionsTab.this.getShell(), (String)"Save As", (String)"Select the parent folder:", (IPath)OptionsTab.this.getRelativeFilePath(OptionsTab.this.textMarkovModelFile.getText().trim()), null);
                if (file != null && (newModelFile = file.getLocation().toOSString()) != null) {
                    String portableString = file.getFullPath().toPortableString();
                    newModelFile = "platform:/resource" + portableString;
                    if (!newModelFile.endsWith(".markov")) {
                        newModelFile = String.valueOf(newModelFile) + ".markov";
                    }
                    OptionsTab.this.textMarkovModelFile.setText(newModelFile);
                    OptionsTab.this.updateLaunchConfigurationDialog();
                    OptionsTab.this.updateFieldsEnablement();
                }
            }
        });
        this.buttonFileSystemFileDialogModelFile = new Button((Composite)markovTransformationGroup, 0);
        this.buttonFileSystemFileDialogModelFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonFileSystemFileDialogModelFile.setText("File System...");
        this.buttonFileSystemFileDialogModelFile.setEnabled(false);
        this.buttonFileSystemFileDialogModelFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDiag = new FileDialog(new Shell(), 8192);
                fileDiag.setFilterPath(OptionsTab.this.getDirectoryName(OptionsTab.this.textMarkovModelFile.getText().trim()));
                fileDiag.setFilterExtensions(new String[]{"*.markov", "*.*"});
                fileDiag.setFileName(OptionsTab.this.getFileName(OptionsTab.this.textMarkovModelFile.getText().trim()));
                fileDiag.setOverwrite(true);
                String modelFile = fileDiag.open();
                if (modelFile != null) {
                    if (fileDiag.getFilterIndex() == 0 && !modelFile.endsWith(".markov")) {
                        modelFile = String.valueOf(modelFile) + ".markov";
                    }
                    OptionsTab.this.textMarkovModelFile.setText(modelFile);
                    OptionsTab.this.updateLaunchConfigurationDialog();
                    OptionsTab.this.updateFieldsEnablement();
                }
            }
        });
        GridLayout evaluationModeLayout = new GridLayout();
        Group evaluationModeGroup = new Group(contentContainer, 0);
        evaluationModeGroup.setLayout((Layout)evaluationModeLayout);
        evaluationModeGroup.setText("Evaluation Mode");
        evaluationModeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.radioSingleFailureMode = new Button((Composite)evaluationModeGroup, 16);
        this.radioSingleFailureMode.setText("Single failure mode (simplified evaluation without failure recovery)");
        this.radioSingleFailureMode.setSelection(MarkovEvaluationType.SINGLE == MARKOV_EVALUATION_MODE);
        this.radioSingleFailureMode.addListener(13, listener);
        this.radioSingleFailureMode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.radioFailureCategories = new Button((Composite)evaluationModeGroup, 16);
        this.radioFailureCategories.setText("Failure categories (simplified evaluation without failure recovery)");
        this.radioFailureCategories.setSelection(MarkovEvaluationType.CLASSES == MARKOV_EVALUATION_MODE);
        this.radioFailureCategories.addListener(13, listener);
        this.radioFailureCategories.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.radioFailureTypes = new Button((Composite)evaluationModeGroup, 16);
        this.radioFailureTypes.setText("Failure types");
        this.radioFailureTypes.setSelection(MarkovEvaluationType.TYPES == MARKOV_EVALUATION_MODE);
        this.radioFailureTypes.addListener(13, listener);
        this.radioFailureTypes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.radioPointsOfFailure = new Button((Composite)evaluationModeGroup, 16);
        this.radioPointsOfFailure.setText("Points of failure (includes detailed reliability report)");
        this.radioPointsOfFailure.setSelection(MarkovEvaluationType.POINTSOFFAILURE == MARKOV_EVALUATION_MODE);
        this.radioPointsOfFailure.addListener(13, listener);
        this.radioPointsOfFailure.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridLayout loggingLayout = new GridLayout();
        loggingLayout.numColumns = 4;
        Group loggingGroup = new Group(contentContainer, 0);
        loggingGroup.setLayout((Layout)loggingLayout);
        loggingGroup.setText("Logging");
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkMarkovStatistics = new Button((Composite)loggingGroup, 32);
        this.checkMarkovStatistics.setLayoutData((Object)new GridData(4, 0x1000000, false, false, loggingLayout.numColumns, 1));
        this.checkMarkovStatistics.setText("Print Markov statistics on console");
        this.checkMarkovStatistics.setSelection(false);
        this.checkMarkovStatistics.addListener(13, listener);
        this.checkSingleResults = new Button((Composite)loggingGroup, 32);
        this.checkSingleResults.setLayoutData((Object)new GridData(4, 0x1000000, false, false, loggingLayout.numColumns, 1));
        this.checkSingleResults.setText("Log results of individual Markov transformation runs");
        this.checkSingleResults.setSelection(false);
        this.checkSingleResults.addListener(13, listener);
        Label labelLogFile = new Label((Composite)loggingGroup, 0);
        labelLogFile.setText("Log file:");
        this.textLogFile = new Text((Composite)loggingGroup, 2048);
        this.textLogFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLogFile.setText("");
        this.textLogFile.setEnabled(false);
        this.textLogFile.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                OptionsTab.this.setDirty(true);
                OptionsTab.this.updateLaunchConfigurationDialog();
                OptionsTab.this.updateFieldsEnablement();
            }
        });
        this.buttonWorkspaceFileDialogLogFile = new Button((Composite)loggingGroup, 0);
        this.buttonWorkspaceFileDialogLogFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonWorkspaceFileDialogLogFile.setText("Workspace...");
        this.buttonWorkspaceFileDialogLogFile.setEnabled(false);
        this.buttonWorkspaceFileDialogLogFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String newLogFile;
                IFile file = WorkspaceResourceDialog.openNewFile((Shell)OptionsTab.this.getShell(), (String)"Save As", (String)"Select the parent folder:", (IPath)OptionsTab.this.getRelativeFilePath(OptionsTab.this.textLogFile.getText().trim()), null);
                if (file != null && (newLogFile = file.getLocation().toOSString()) != null) {
                    String portableString = file.getFullPath().toPortableString();
                    newLogFile = "platform:/resource" + portableString;
                    if (!newLogFile.endsWith(".txt")) {
                        newLogFile = String.valueOf(newLogFile) + ".txt";
                    }
                    OptionsTab.this.textLogFile.setText(newLogFile);
                    OptionsTab.this.updateLaunchConfigurationDialog();
                    OptionsTab.this.updateFieldsEnablement();
                }
            }
        });
        this.buttonFileSystemFileDialogLogFile = new Button((Composite)loggingGroup, 0);
        this.buttonFileSystemFileDialogLogFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonFileSystemFileDialogLogFile.setText("File System...");
        this.buttonFileSystemFileDialogLogFile.setEnabled(false);
        this.buttonFileSystemFileDialogLogFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDiag = new FileDialog(new Shell(), 8192);
                fileDiag.setFilterPath(OptionsTab.this.getDirectoryName(OptionsTab.this.textLogFile.getText().trim()));
                fileDiag.setFilterExtensions(new String[]{"*.txt", "*.*"});
                fileDiag.setFileName(OptionsTab.this.getFileName(OptionsTab.this.textLogFile.getText().trim()));
                fileDiag.setOverwrite(true);
                String logFile = fileDiag.open();
                if (logFile != null) {
                    if (fileDiag.getFilterIndex() == 0 && !logFile.endsWith(".txt")) {
                        logFile = String.valueOf(logFile) + ".txt";
                    }
                    OptionsTab.this.textLogFile.setText(logFile);
                    OptionsTab.this.updateLaunchConfigurationDialog();
                    OptionsTab.this.updateFieldsEnablement();
                }
            }
        });
        GridLayout markovAnalysisResultsLayout = new GridLayout();
        markovAnalysisResultsLayout.numColumns = 4;
        Group markovAnalysisResultsGroup = new Group(contentContainer, 0);
        markovAnalysisResultsGroup.setLayout((Layout)markovAnalysisResultsLayout);
        markovAnalysisResultsGroup.setText("Markov Analysis Results");
        markovAnalysisResultsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkSaveResultsToFile = new Button((Composite)markovAnalysisResultsGroup, 32);
        this.checkSaveResultsToFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, markovAnalysisResultsLayout.numColumns, 1));
        this.checkSaveResultsToFile.setText("Save results to file");
        this.checkSaveResultsToFile.setSelection(false);
        this.checkSaveResultsToFile.addListener(13, listener);
        Label labelSaveResultsToFile = new Label((Composite)markovAnalysisResultsGroup, 0);
        labelSaveResultsToFile.setText("File:");
        this.textSaveResultsToFile = new Text((Composite)markovAnalysisResultsGroup, 2048);
        this.textSaveResultsToFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textSaveResultsToFile.setText("");
        this.textSaveResultsToFile.setEnabled(false);
        this.textSaveResultsToFile.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                OptionsTab.this.setDirty(true);
                OptionsTab.this.updateLaunchConfigurationDialog();
                OptionsTab.this.updateFieldsEnablement();
            }
        });
        this.buttonWorkspaceFileDialogSaveToFile = new Button((Composite)markovAnalysisResultsGroup, 0);
        this.buttonWorkspaceFileDialogSaveToFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonWorkspaceFileDialogSaveToFile.setText("Workspace...");
        this.buttonWorkspaceFileDialogSaveToFile.setEnabled(false);
        this.buttonWorkspaceFileDialogSaveToFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String newSaveToFile;
                IFile file = WorkspaceResourceDialog.openNewFile((Shell)OptionsTab.this.getShell(), (String)"Save As", (String)"Select the parent folder:", (IPath)OptionsTab.this.getRelativeFilePath(OptionsTab.this.textSaveResultsToFile.getText().trim()), null);
                if (file != null && (newSaveToFile = file.getLocation().toOSString()) != null) {
                    String portableString = file.getFullPath().toPortableString();
                    newSaveToFile = "platform:/resource" + portableString;
                    if (!newSaveToFile.endsWith(".markovresult")) {
                        newSaveToFile = String.valueOf(newSaveToFile) + ".markovresult";
                    }
                    OptionsTab.this.textSaveResultsToFile.setText(newSaveToFile);
                    OptionsTab.this.updateLaunchConfigurationDialog();
                    OptionsTab.this.updateFieldsEnablement();
                }
            }
        });
        this.buttonFileSystemFileDialogSaveToFile = new Button((Composite)markovAnalysisResultsGroup, 0);
        this.buttonFileSystemFileDialogSaveToFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonFileSystemFileDialogSaveToFile.setText("File System...");
        this.buttonFileSystemFileDialogSaveToFile.setEnabled(false);
        this.buttonFileSystemFileDialogSaveToFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDiag = new FileDialog(new Shell(), 8192);
                fileDiag.setFilterPath(OptionsTab.this.getDirectoryName(OptionsTab.this.textSaveResultsToFile.getText().trim()));
                fileDiag.setFilterExtensions(new String[]{"*.markovresult", "*.*"});
                fileDiag.setFileName(OptionsTab.this.getFileName(OptionsTab.this.textSaveResultsToFile.getText().trim()));
                fileDiag.setOverwrite(true);
                String saveToFile = fileDiag.open();
                if (saveToFile != null) {
                    if (fileDiag.getFilterIndex() == 0 && !saveToFile.endsWith(".markovresult")) {
                        saveToFile = String.valueOf(saveToFile) + ".markovresult";
                    }
                    OptionsTab.this.textSaveResultsToFile.setText(saveToFile);
                    OptionsTab.this.updateLaunchConfigurationDialog();
                    OptionsTab.this.updateFieldsEnablement();
                }
            }
        });
        container.setMinSize(contentContainer.computeSize(-1, -1));
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private Path getCurrentFilePath(String path) {
        Path resultPath;
        if (Path.ROOT.isValidPath(path) && (resultPath = new Path(path)).isAbsolute()) {
            return resultPath;
        }
        return null;
    }

    private String getDirectoryName(String path) {
        Path filePath = this.getCurrentFilePath(path);
        if (filePath == null) {
            return null;
        }
        if (filePath.toFile().isDirectory()) {
            return filePath.toOSString();
        }
        return new Path(filePath.toFile().getParent()).toOSString();
    }

    private String getFileName(String path) {
        Path filePath = this.getCurrentFilePath(path);
        if (filePath == null || filePath.toFile().isDirectory()) {
            return null;
        }
        return filePath.toFile().getName();
    }

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)FILENAME_TAB_IMAGE_PATH);
    }

    public String getName() {
        return "Analysis Options";
    }

    private Path getRelativeFilePath(String path) {
        Path logFilePath = this.getCurrentFilePath(path);
        Path workspacePath = (Path)ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path resultPath = new Path("");
        if (logFilePath != null && workspacePath.isPrefixOf((IPath)logFilePath)) {
            resultPath = (Path)logFilePath.makeRelativeTo((IPath)workspacePath);
        }
        return resultPath;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            MarkovEvaluationType evalType;
            this.checkMarkovStatistics.setSelection(configuration.getAttribute("markovStatistics", false));
            this.checkSingleResults.setSelection(configuration.getAttribute("singleResults", false));
            this.checkNumberOfEvaluatedSystemStates.setSelection(configuration.getAttribute("numberOfEvaluatedSystemStatesEnabled", false));
            this.checkNumberOfExactDecimalPlaces.setSelection(configuration.getAttribute("numberOfExactDecimalPlacesEnabled", false));
            this.checkSolvingTimeLimit.setSelection(configuration.getAttribute("solvingTimeLimitEnabled", false));
            this.spinnerNumberOfEvaluatedSystemStates.setSelection(configuration.getAttribute("numberOfEvaluatedSystemStates", 1));
            this.spinnerNumberOfExactDecimalPlaces.setSelection(configuration.getAttribute("numberOfExactDecimalPlaces", 1));
            this.spinnerSolvingTimeLimit.setSelection(configuration.getAttribute("solvingTimeLimit", 1));
            this.textLogFile.setEnabled(configuration.getAttribute("singleResults", false));
            this.textLogFile.setText(configuration.getAttribute("logFile", ""));
            this.buttonWorkspaceFileDialogLogFile.setEnabled(configuration.getAttribute("singleResults", false));
            this.buttonFileSystemFileDialogLogFile.setEnabled(configuration.getAttribute("singleResults", false));
            this.checkOptimize.setSelection(configuration.getAttribute("markovModelReduction", true));
            this.checkMarkovModelTraces.setSelection(configuration.getAttribute("markovModelTracesEnabled", false));
            this.checkIterateOverPhysicalSystemStates.setSelection(configuration.getAttribute("iterationOverPhysicalSystemStatesEnabled", true));
            this.checkStoreMarkovModel.setSelection(configuration.getAttribute("markovModelStorageEnabled", false));
            this.textMarkovModelFile.setEnabled(configuration.getAttribute("markovModelStorageEnabled", false));
            this.textMarkovModelFile.setText(configuration.getAttribute("markovModelFile", ""));
            this.buttonWorkspaceFileDialogModelFile.setEnabled(configuration.getAttribute("markovModelStorageEnabled", false));
            this.buttonFileSystemFileDialogModelFile.setEnabled(configuration.getAttribute("markovModelStorageEnabled", false));
            this.checkSaveResultsToFile.setSelection(configuration.getAttribute("saveResultsToFileEnabled", false));
            this.textSaveResultsToFile.setEnabled(configuration.getAttribute("saveResultsToFileEnabled", false));
            this.textSaveResultsToFile.setText(configuration.getAttribute("saveFileDefault", ""));
            this.buttonWorkspaceFileDialogSaveToFile.setEnabled(configuration.getAttribute("saveResultsToFileEnabled", false));
            this.buttonFileSystemFileDialogSaveToFile.setEnabled(configuration.getAttribute("saveResultsToFileEnabled", false));
            try {
                evalType = MarkovEvaluationType.valueOf((String)configuration.getAttribute("markovEvaluationMode", MARKOV_EVALUATION_MODE.toString()));
            }
            catch (IllegalArgumentException e) {
                evalType = MARKOV_EVALUATION_MODE;
            }
            this.radioFailureCategories.setSelection(MarkovEvaluationType.CLASSES == evalType);
            this.radioPointsOfFailure.setSelection(MarkovEvaluationType.POINTSOFFAILURE == evalType);
            this.radioSingleFailureMode.setSelection(MarkovEvaluationType.SINGLE == evalType);
            this.radioFailureTypes.setSelection(MarkovEvaluationType.TYPES == evalType);
        }
        catch (CoreException e) {
            this.checkMarkovStatistics.setSelection(false);
            this.checkSingleResults.setSelection(false);
            this.checkNumberOfEvaluatedSystemStates.setSelection(false);
            this.spinnerNumberOfEvaluatedSystemStates.setSelection(1);
            this.checkNumberOfExactDecimalPlaces.setSelection(false);
            this.spinnerNumberOfExactDecimalPlaces.setSelection(1);
            this.checkSolvingTimeLimit.setSelection(false);
            this.spinnerSolvingTimeLimit.setSelection(1);
            this.textLogFile.setEnabled(false);
            this.textLogFile.setText("");
            this.buttonWorkspaceFileDialogLogFile.setEnabled(false);
            this.buttonFileSystemFileDialogLogFile.setEnabled(false);
            this.checkOptimize.setSelection(true);
            this.checkMarkovModelTraces.setSelection(false);
            this.checkIterateOverPhysicalSystemStates.setSelection(true);
            this.checkStoreMarkovModel.setSelection(false);
            this.textMarkovModelFile.setEnabled(false);
            this.textMarkovModelFile.setText("");
            this.buttonWorkspaceFileDialogModelFile.setEnabled(false);
            this.buttonFileSystemFileDialogModelFile.setEnabled(false);
            this.radioSingleFailureMode.setSelection(MarkovEvaluationType.SINGLE == MARKOV_EVALUATION_MODE);
            this.radioFailureCategories.setSelection(MarkovEvaluationType.CLASSES == MARKOV_EVALUATION_MODE);
            this.radioFailureTypes.setSelection(MarkovEvaluationType.TYPES == MARKOV_EVALUATION_MODE);
            this.radioPointsOfFailure.setSelection(MarkovEvaluationType.POINTSOFFAILURE == MARKOV_EVALUATION_MODE);
            this.checkSaveResultsToFile.setSelection(false);
            this.textSaveResultsToFile.setEnabled(false);
            this.textSaveResultsToFile.setText("");
            this.buttonWorkspaceFileDialogSaveToFile.setEnabled(false);
            this.buttonFileSystemFileDialogSaveToFile.setEnabled(false);
        }
        this.updateLaunchConfigurationDialog();
        this.updateFieldsEnablement();
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        if (this.checkSingleResults.getSelection()) {
            if (this.getCurrentFilePath(this.resolvePath(this.textLogFile.getText().trim())) == null) {
                this.setErrorMessage("Invalid log file!");
                return false;
            }
            if (this.getCurrentFilePath(this.resolveFile(this.textLogFile.getText().trim())).toFile().isDirectory()) {
                this.setErrorMessage("Log file is a directory!");
                return false;
            }
            if (!this.getCurrentFilePath(this.resolvePath(this.textLogFile.getText().trim())).toFile().getParentFile().exists()) {
                this.setErrorMessage("Log file directory does not exist!");
                return false;
            }
        }
        if (this.checkStoreMarkovModel.getSelection()) {
            if (this.getCurrentFilePath(this.resolvePath(this.textMarkovModelFile.getText().trim())) == null) {
                this.setErrorMessage("Invalid Markov model file!");
                return false;
            }
            if (this.getCurrentFilePath(this.resolveFile(this.textMarkovModelFile.getText().trim())).toFile().isDirectory()) {
                this.setErrorMessage("Markov model file is a directory!");
                return false;
            }
            if (!this.getCurrentFilePath(this.resolvePath(this.textMarkovModelFile.getText().trim())).toFile().getParentFile().exists()) {
                this.setErrorMessage("Markov model file directory does not exist!");
                return false;
            }
        }
        if (this.checkSaveResultsToFile.getSelection()) {
            if (this.getCurrentFilePath(this.resolvePath(this.textSaveResultsToFile.getText().trim())) == null) {
                this.setErrorMessage("Invalid results file!");
                return false;
            }
            if (this.getCurrentFilePath(this.resolveFile(this.textSaveResultsToFile.getText().trim())).toFile().isDirectory()) {
                this.setErrorMessage("Results file is a directory!");
                return false;
            }
            if (!this.getCurrentFilePath(this.resolvePath(this.textSaveResultsToFile.getText().trim())).toFile().getParentFile().exists()) {
                this.setErrorMessage("Results file directory does not exist!");
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("markovStatistics", this.checkMarkovStatistics.getSelection());
        configuration.setAttribute("singleResults", this.checkSingleResults.getSelection());
        configuration.setAttribute("numberOfEvaluatedSystemStatesEnabled", this.checkNumberOfEvaluatedSystemStates.getSelection());
        configuration.setAttribute("numberOfEvaluatedSystemStates", Integer.parseInt(this.spinnerNumberOfEvaluatedSystemStates.getText()));
        configuration.setAttribute("numberOfExactDecimalPlacesEnabled", this.checkNumberOfExactDecimalPlaces.getSelection());
        configuration.setAttribute("numberOfExactDecimalPlaces", Integer.parseInt(this.spinnerNumberOfExactDecimalPlaces.getText()));
        configuration.setAttribute("solvingTimeLimitEnabled", this.checkSolvingTimeLimit.getSelection());
        configuration.setAttribute("solvingTimeLimit", Integer.parseInt(this.spinnerSolvingTimeLimit.getText()));
        configuration.setAttribute("logFile", this.textLogFile.getText().trim());
        configuration.setAttribute("markovModelReduction", this.checkOptimize.getSelection());
        configuration.setAttribute("markovModelTracesEnabled", this.checkMarkovModelTraces.getSelection());
        configuration.setAttribute("iterationOverPhysicalSystemStatesEnabled", this.checkIterateOverPhysicalSystemStates.getSelection());
        configuration.setAttribute("markovModelStorageEnabled", this.checkStoreMarkovModel.getSelection());
        configuration.setAttribute("markovModelFile", this.textMarkovModelFile.getText().trim());
        if (this.radioSingleFailureMode.getSelection()) {
            configuration.setAttribute("markovEvaluationMode", MarkovEvaluationType.SINGLE.toString());
        } else if (this.radioFailureCategories.getSelection()) {
            configuration.setAttribute("markovEvaluationMode", MarkovEvaluationType.CLASSES.toString());
        } else if (this.radioFailureTypes.getSelection()) {
            configuration.setAttribute("markovEvaluationMode", MarkovEvaluationType.TYPES.toString());
        } else if (this.radioPointsOfFailure.getSelection()) {
            configuration.setAttribute("markovEvaluationMode", MarkovEvaluationType.POINTSOFFAILURE.toString());
        }
        configuration.setAttribute("saveResultsToFileEnabled", this.checkSaveResultsToFile.getSelection());
        configuration.setAttribute("saveFileDefault", this.textSaveResultsToFile.getText().trim());
    }

    private String resolveFile(String fileURL) {
        if (fileURL.startsWith("platform:")) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(fileURL));
                fileURL = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return fileURL;
    }

    private String resolvePath(String fileURL) {
        int indexSlash;
        int indexBackslash;
        if (fileURL.startsWith("platform:")) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(fileURL));
                fileURL = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        int index = (indexBackslash = fileURL.lastIndexOf("\\")) > (indexSlash = fileURL.lastIndexOf("/")) ? indexBackslash : indexSlash;
        String folderPath = fileURL.substring(0, index + 1);
        return folderPath;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("markovStatistics", false);
        configuration.setAttribute("singleResults", false);
        configuration.setAttribute("numberOfEvaluatedSystemStatesEnabled", false);
        configuration.setAttribute("numberOfEvaluatedSystemStates", 1);
        configuration.setAttribute("numberOfExactDecimalPlacesEnabled", false);
        configuration.setAttribute("numberOfExactDecimalPlaces", 1);
        configuration.setAttribute("solvingTimeLimitEnabled", false);
        configuration.setAttribute("solvingTimeLimit", 1);
        configuration.setAttribute("logFile", "");
        configuration.setAttribute("markovModelReduction", true);
        configuration.setAttribute("markovModelTracesEnabled", false);
        configuration.setAttribute("iterationOverPhysicalSystemStatesEnabled", true);
        configuration.setAttribute("markovModelStorageEnabled", false);
        configuration.setAttribute("markovModelFile", "");
        configuration.setAttribute("markovEvaluationMode", MARKOV_EVALUATION_MODE.toString());
    }

    private void updateFieldsEnablement() {
        this.spinnerNumberOfEvaluatedSystemStates.setEnabled(this.checkNumberOfEvaluatedSystemStates.getSelection());
        this.spinnerNumberOfExactDecimalPlaces.setEnabled(this.checkNumberOfExactDecimalPlaces.getSelection());
        this.spinnerSolvingTimeLimit.setEnabled(this.checkSolvingTimeLimit.getSelection());
        this.textLogFile.setEnabled(this.checkSingleResults.getSelection());
        this.buttonWorkspaceFileDialogLogFile.setEnabled(this.checkSingleResults.getSelection());
        this.buttonFileSystemFileDialogLogFile.setEnabled(this.checkSingleResults.getSelection());
        this.textMarkovModelFile.setEnabled(this.checkStoreMarkovModel.getSelection());
        this.buttonWorkspaceFileDialogModelFile.setEnabled(this.checkStoreMarkovModel.getSelection());
        this.buttonFileSystemFileDialogModelFile.setEnabled(this.checkStoreMarkovModel.getSelection());
        this.textSaveResultsToFile.setEnabled(this.checkSaveResultsToFile.getSelection());
        this.buttonWorkspaceFileDialogSaveToFile.setEnabled(this.checkSaveResultsToFile.getSelection());
        this.buttonFileSystemFileDialogSaveToFile.setEnabled(this.checkSaveResultsToFile.getSelection());
    }
}

