/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.runconfig;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.core.ConstantsContainer;
import org.palladiosimulator.analyzer.workflow.runconfig.ConfigurationTab;

public class ReliabilityConfigurationTab
extends ConfigurationTab {
    private static final String BUTTON_SENSITIVITY_LABEL = "Perform sensitivity analysis";
    private static final String GROUP_SENSITIVITY_LABEL = "Sensitivity analysis";
    private static final String LOG_FILE_LABEL = "Sensitivity Result Log File";
    private static final String SENSITIVITY_FILE_LABEL = "Sensitivity Model File";
    private Button sensitivityButton;
    private Text textResultLogFile;
    private Text textSensitivityFile;

    protected void createFurtherSections(Composite container) {
        Group sensitivityGroup = new Group(container, 0);
        sensitivityGroup.setText(GROUP_SENSITIVITY_LABEL);
        GridData gd_sensitivityGroup = new GridData(4, 0x1000000, true, false);
        sensitivityGroup.setLayoutData((Object)gd_sensitivityGroup);
        sensitivityGroup.setLayout((Layout)new GridLayout());
        this.sensitivityButton = new Button((Composite)sensitivityGroup, 32);
        this.sensitivityButton.setLayoutData((Object)gd_sensitivityGroup);
        this.sensitivityButton.setText(BUTTON_SENSITIVITY_LABEL);
        this.sensitivityButton.setSelection(false);
        this.sensitivityButton.addSelectionListener(this.selectionListener);
        this.textSensitivityFile = new Text((Composite)sensitivityGroup, 2052);
        this.textSensitivityFile.setLayoutData((Object)gd_sensitivityGroup);
        this.textSensitivityFile.addModifyListener(this.modifyListener);
        TabHelper.createFileInputSection((Composite)sensitivityGroup, (ModifyListener)this.modifyListener, (String)SENSITIVITY_FILE_LABEL, (String[])ConstantsContainer.SENSITIVITY_ANALYSIS_EXTENSION, (Text)this.textSensitivityFile, (Shell)this.getShell(), (String)"");
        this.textResultLogFile = new Text((Composite)sensitivityGroup, 2052);
        this.textResultLogFile.setLayoutData((Object)gd_sensitivityGroup);
        this.textResultLogFile.addModifyListener(this.modifyListener);
        TabHelper.createFileInputSection((Composite)sensitivityGroup, (ModifyListener)this.modifyListener, (String)LOG_FILE_LABEL, (String[])ConstantsContainer.SENSITIVITY_LOG_EXTENSION, (Text)this.textResultLogFile, (Shell)this.getShell(), (String)"");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.sensitivityButton.setSelection(configuration.getAttribute("doSensitivityAnalysis", ConstantsContainer.DEFAULT_DO_SENSITIVITY_ANALYSIS.booleanValue()));
            this.textSensitivityFile.setText(configuration.getAttribute("sensitivityModelFile", ""));
            this.textResultLogFile.setText(configuration.getAttribute("sensitivityLogFile", ""));
        }
        catch (CoreException e) {
            this.sensitivityButton.setSelection(ConstantsContainer.DEFAULT_DO_SENSITIVITY_ANALYSIS.booleanValue());
            this.textSensitivityFile.setText("");
            this.textResultLogFile.setText("");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        if (this.sensitivityButton.getSelection()) {
            if (!TabHelper.validateFilenameExtension((String)this.textSensitivityFile.getText(), (String[])ConstantsContainer.SENSITIVITY_ANALYSIS_EXTENSION)) {
                this.setErrorMessage("Sensitivity Model File must be present for sensitivity analysis.");
                return false;
            }
            if (!TabHelper.validateFilenameExtension((String)this.textResultLogFile.getText(), (String[])ConstantsContainer.SENSITIVITY_LOG_EXTENSION)) {
                this.setErrorMessage("Sensitivity Result Log File must be present for sensitivity analysis.");
                return false;
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("doSensitivityAnalysis", this.sensitivityButton.getSelection());
        configuration.setAttribute("sensitivityModelFile", this.textSensitivityFile.getText());
        configuration.setAttribute("sensitivityLogFile", this.textResultLogFile.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("doSensitivityAnalysis", (Object)ConstantsContainer.DEFAULT_DO_SENSITIVITY_ANALYSIS);
        configuration.setAttribute("sensitivityModelFile", "");
        configuration.setAttribute("sensitivityLogFile", "");
    }
}

