/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.SpecifiedQoSAnnotation;
import org.palladiosimulator.pcm.qosannotations.qos_reliability.SpecifiedReliabilityAnnotation;
import org.palladiosimulator.pcm.reliability.ExternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;
import org.palladiosimulator.reliability.MarkovHardwareInducedFailureType;
import org.palladiosimulator.reliability.MarkovNetworkInducedFailureType;
import org.palladiosimulator.reliability.MarkovResourceTimeoutFailureType;
import org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType;
import org.palladiosimulator.reliability.helper.EMFHelper;

public class MarkovFailureTypeHelper {
    private EMFHelper helper = new EMFHelper();

    public List<MarkovFailureType> getFailureTypes(MarkovEvaluationType evaluationType, List<Repository> repositories, ResourceEnvironment environment, System system) {
        List<MarkovFailureType> failureTypes = this.getNetworkFailureTypes(evaluationType, environment, system);
        failureTypes.addAll(this.getHardwareFailureTypes(evaluationType, environment, system));
        failureTypes.addAll(this.getResourceTimeoutFailureTypes(evaluationType, system));
        failureTypes.addAll(this.getSoftwareFailureTypes(evaluationType, repositories, system));
        return this.removeDoubleFailureTypes(failureTypes);
    }

    private List<MarkovFailureType> getHardwareFailureTypes(MarkovEvaluationType evaluationType, ResourceEnvironment environment, System system) {
        ArrayList<MarkovFailureType> resultList = new ArrayList<MarkovFailureType>();
        for (ResourceContainer container : environment.getResourceContainer_ResourceEnvironment()) {
            for (ProcessingResourceSpecification specification : container.getActiveResourceSpecifications_ResourceContainer()) {
                ProcessingResourceType resourceType = specification.getActiveResourceType_ActiveResourceSpecification();
                resultList.add(MarkovHardwareInducedFailureType.createInternalFailureType(evaluationType, container, resourceType));
            }
        }
        for (QoSAnnotations qos : system.getQosAnnotations_System()) {
            for (SpecifiedQoSAnnotation annotation : qos.getSpecifiedQoSAnnotations_QoSAnnotations()) {
                if (!(annotation instanceof SpecifiedReliabilityAnnotation)) continue;
                SpecifiedReliabilityAnnotation relAnnotation = (SpecifiedReliabilityAnnotation)annotation;
                for (ExternalFailureOccurrenceDescription description : relAnnotation.getExternalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation()) {
                    FailureType failureType = description.getFailureType__ExternalFailureOccurrenceDescription();
                    if (!(failureType instanceof HardwareInducedFailureType)) continue;
                    HardwareInducedFailureType hardwareFailureType = (HardwareInducedFailureType)failureType;
                    resultList.add(MarkovHardwareInducedFailureType.createExternalFailureType(evaluationType, hardwareFailureType.getProcessingResourceType__HardwareInducedFailureType(), annotation.getSignature_SpecifiedQoSAnnation(), annotation.getRole_SpecifiedQoSAnnotation(), (Interface)((OperationRequiredRole)annotation.getRole_SpecifiedQoSAnnotation()).getRequiredInterface__OperationRequiredRole()));
                }
            }
        }
        return resultList;
    }

    private List<MarkovFailureType> getNetworkFailureTypes(MarkovEvaluationType evaluationType, ResourceEnvironment environment, System system) {
        ArrayList<MarkovFailureType> resultList = new ArrayList<MarkovFailureType>();
        for (LinkingResource commLink : environment.getLinkingResources__ResourceEnvironment()) {
            CommunicationLinkResourceSpecification specification = commLink.getCommunicationLinkResourceSpecifications_LinkingResource();
            CommunicationLinkResourceType resourceType = specification.getCommunicationLinkResourceType_CommunicationLinkResourceSpecification();
            resultList.add(MarkovNetworkInducedFailureType.createInternalFailureType(evaluationType, commLink, resourceType));
        }
        for (QoSAnnotations qos : system.getQosAnnotations_System()) {
            for (SpecifiedQoSAnnotation annotation : qos.getSpecifiedQoSAnnotations_QoSAnnotations()) {
                if (!(annotation instanceof SpecifiedReliabilityAnnotation)) continue;
                SpecifiedReliabilityAnnotation relAnnotation = (SpecifiedReliabilityAnnotation)annotation;
                for (ExternalFailureOccurrenceDescription description : relAnnotation.getExternalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation()) {
                    FailureType failureType = description.getFailureType__ExternalFailureOccurrenceDescription();
                    if (!(failureType instanceof NetworkInducedFailureType)) continue;
                    CommunicationLinkResourceType resourceType = ((NetworkInducedFailureType)failureType).getCommunicationLinkResourceType__NetworkInducedFailureType();
                    resultList.add(MarkovNetworkInducedFailureType.createExternalFailureType(evaluationType, resourceType, annotation.getSignature_SpecifiedQoSAnnation(), annotation.getRole_SpecifiedQoSAnnotation(), (Interface)((OperationRequiredRole)annotation.getRole_SpecifiedQoSAnnotation()).getRequiredInterface__OperationRequiredRole()));
                }
            }
        }
        return resultList;
    }

    private List<MarkovFailureType> getResourceTimeoutFailureTypes(MarkovEvaluationType evaluationType, System system) {
        ArrayList<MarkovFailureType> resultList = new ArrayList<MarkovFailureType>();
        for (AssemblyContext context : system.getAssemblyContexts__ComposedStructure()) {
            RepositoryComponent component = context.getEncapsulatedComponent__AssemblyContext();
            if (!(component instanceof BasicComponent)) continue;
            for (PassiveResource resource : ((BasicComponent)component).getPassiveResource_BasicComponent()) {
                resultList.add(MarkovResourceTimeoutFailureType.createResourceTimeoutFailureType(evaluationType, context, (BasicComponent)component, resource));
            }
        }
        return resultList;
    }

    private List<MarkovFailureType> getSoftwareFailureTypes(MarkovEvaluationType evaluationType, List<Repository> repositories, System system) {
        ArrayList<MarkovFailureType> resultList = new ArrayList<MarkovFailureType>();
        for (Repository repository : repositories) {
            EList<EObject> components = this.helper.getElements((EObject)repository, RepositoryFactory.eINSTANCE.createBasicComponent().eClass());
            for (Object c_object : components) {
                BasicComponent component = (BasicComponent)c_object;
                for (ProvidedRole role : component.getProvidedRoles_InterfaceProvidingEntity()) {
                    if (!(role instanceof OperationProvidedRole)) continue;
                    OperationProvidedRole opRole = (OperationProvidedRole)role;
                    OperationInterface iface = opRole.getProvidedInterface__OperationProvidedRole();
                    for (OperationSignature signature : iface.getSignatures__OperationInterface()) {
                        ServiceEffectSpecification rdseff = this.getRDSEFF(component, signature);
                        EList<EObject> internalActions = this.helper.getElements((EObject)rdseff, SeffFactory.eINSTANCE.createInternalAction().eClass());
                        for (Object a_object : internalActions) {
                            InternalAction internalAction = (InternalAction)a_object;
                            for (InternalFailureOccurrenceDescription description : internalAction.getInternalFailureOccurrenceDescriptions__InternalAction()) {
                                resultList.add(MarkovSoftwareInducedFailureType.createInternalFailureType(evaluationType, description.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription(), internalAction, (Signature)signature, (Role)opRole, (Interface)iface, component));
                            }
                        }
                    }
                }
            }
        }
        for (QoSAnnotations qos : system.getQosAnnotations_System()) {
            for (SpecifiedQoSAnnotation annotation : qos.getSpecifiedQoSAnnotations_QoSAnnotations()) {
                if (!(annotation instanceof SpecifiedReliabilityAnnotation)) continue;
                SpecifiedReliabilityAnnotation relAnnotation = (SpecifiedReliabilityAnnotation)annotation;
                for (ExternalFailureOccurrenceDescription description : relAnnotation.getExternalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation()) {
                    FailureType failureType = description.getFailureType__ExternalFailureOccurrenceDescription();
                    if (!(failureType instanceof SoftwareInducedFailureType)) continue;
                    SoftwareInducedFailureType softwareFailureType = (SoftwareInducedFailureType)failureType;
                    resultList.add(MarkovSoftwareInducedFailureType.createExternalFailureType(evaluationType, softwareFailureType, annotation.getSignature_SpecifiedQoSAnnation(), annotation.getRole_SpecifiedQoSAnnotation(), (Interface)((OperationRequiredRole)annotation.getRole_SpecifiedQoSAnnotation()).getRequiredInterface__OperationRequiredRole()));
                }
            }
        }
        return resultList;
    }

    private ServiceEffectSpecification getRDSEFF(BasicComponent component, OperationSignature signature) {
        for (ServiceEffectSpecification rdseff : component.getServiceEffectSpecifications__BasicComponent()) {
            if (!rdseff.getDescribedService__SEFF().getId().equals(signature.getId())) continue;
            return rdseff;
        }
        return null;
    }

    private List<MarkovFailureType> removeDoubleFailureTypes(List<MarkovFailureType> failureTypes) {
        ArrayList<MarkovFailureType> resultList = new ArrayList<MarkovFailureType>();
        for (MarkovFailureType failureType : failureTypes) {
            if (resultList.contains(failureType)) continue;
            resultList.add(failureType);
        }
        return resultList;
    }
}

