/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.probe;

import java.util.Map;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;
import org.palladiosimulator.measurementframework.measure.IdentifierMeasure;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.DataType;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.Scale;
import org.palladiosimulator.metricspec.util.builder.TextualBaseMetricDescriptionBuilder;
import org.palladiosimulator.probeframework.probes.BasicEventProbe;
import org.palladiosimulator.reliability.FailureStatistics;
import org.palladiosimulator.reliability.IFailureStatisticsListener;
import org.palladiosimulator.reliability.MarkovFailureType;

public class TakeExecutionResultProbe
extends BasicEventProbe<FailureStatistics, Identifier, Dimensionless>
implements IFailureStatisticsListener {
    public TakeExecutionResultProbe(FailureStatistics failureStatistics, Map<MarkovFailureType, Identifier> simFailureTypes, Identifier successIdentifier) {
        super((Object)failureStatistics, TakeExecutionResultProbe.createMetricDescription(simFailureTypes, successIdentifier));
    }

    private static BaseMetricDescription createMetricDescription(Map<MarkovFailureType, Identifier> simFailureTypes, Identifier successIdentifier) {
        return TextualBaseMetricDescriptionBuilder.newTextualBaseMetricDescriptionBuilder().name("Execution Result").textualDescription("Enumeration of all failure types which might happen in a reliability simulation").scale(Scale.NOMINAL).dataType(DataType.QUANTITATIVE).identifiers(simFailureTypes.values()).identifiers(successIdentifier).build();
    }

    protected void registerListener() {
        ((FailureStatistics)((Object)this.eventSource)).addObserver(this);
    }

    @Override
    public void executionResultRecorder(MarkovFailureType failureType) {
        Identifier resultFailureIdentifier = ((FailureStatistics)((Object)this.eventSource)).getExecutionResultId(failureType);
        IdentifierMeasure result = IdentifierMeasure.valueOf((Identifier)resultFailureIdentifier, (Unit)Unit.ONE);
        this.notify((Measure)result);
    }
}

