/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability;

import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;

public class MarkovResourceTimeoutFailureType
extends MarkovFailureType {
    private static String RESOURCE_ID = "Passive resource timeout failure";
    private static String RESOURCE_NAME = "Passive resource timeout failure";
    private String assemblyContextId = "";
    private String assemblyContextName = "";
    private String componentId = "";
    private String componentName = "";
    private String passiveResourceId = "";
    private String passiveResourceName = "";

    public static MarkovResourceTimeoutFailureType createResourceTimeoutFailureType(MarkovEvaluationType evaluationType, AssemblyContext assemblyContext, BasicComponent component, PassiveResource passiveResource) {
        return new MarkovResourceTimeoutFailureType(evaluationType, assemblyContext.getId(), assemblyContext.getEntityName(), component.getId(), component.getEntityName(), passiveResource.getId(), passiveResource.getEntityName());
    }

    public static MarkovResourceTimeoutFailureType createResourceTimeoutFailureType(MarkovEvaluationType evaluationType, String assemblyContextId, String passiveResourceId) {
        return new MarkovResourceTimeoutFailureType(evaluationType, assemblyContextId, "", "", "", passiveResourceId, "");
    }

    private MarkovResourceTimeoutFailureType(MarkovEvaluationType evaluationType, String assemblyContextId, String assemblyContextName, String componentId, String componentName, String passiveResourceId, String passiveResourceName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(assemblyContextId) + "/" + passiveResourceId;
                this.name = String.valueOf(assemblyContextName) + "/" + passiveResourceName + " (system-internal passive resource timeout failure)";
                break;
            }
            case TYPES: {
                this.id = passiveResourceId;
                this.name = String.valueOf(passiveResourceName) + " (passive resource timeout failure)";
                break;
            }
            case CLASSES: {
                this.id = RESOURCE_ID;
                this.name = RESOURCE_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.assemblyContextId = assemblyContextId;
        this.assemblyContextName = assemblyContextName;
        this.componentId = componentId;
        this.componentName = componentName;
        this.passiveResourceId = passiveResourceId;
        this.passiveResourceName = passiveResourceName;
        this.systemExternal = false;
    }

    public String getAssemblyContextId() {
        return this.assemblyContextId;
    }

    public String getAssemblyContextName() {
        return this.assemblyContextName;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getPassiveResourceId() {
        return this.passiveResourceId;
    }

    public String getPassiveResourceName() {
        return this.passiveResourceName;
    }
}

