/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;

public class InternalActionSensitivity
extends MarkovSensitivity {
    private double baseValue;
    private InternalFailureOccurrenceDescription description = null;
    private String failureTypeId;
    private String internalActionId;

    public InternalActionSensitivity(String name, String internalActionId, String failureTypeId, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
        this.internalActionId = internalActionId;
        this.failureTypeId = failureTypeId;
    }

    @Override
    protected boolean alterModel() {
        if (this.description == null) {
            return false;
        }
        this.description.setFailureProbability(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValue));
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        List repositories = this.getModel().getRepositories();
        if (repositories.size() == 0) {
            LOGGER.error((Object)"No PCM Repositories found.");
            return;
        }
        InternalAction internalAction = null;
        for (Repository repository : repositories) {
            EList internalActions = this.helper.getElements((EObject)repository, SeffFactory.eINSTANCE.createInternalAction().eClass());
            for (EObject action : internalActions) {
                if (!((InternalAction)action).getId().equals(this.internalActionId)) continue;
                internalAction = (InternalAction)action;
                break;
            }
            if (internalAction != null) break;
        }
        if (internalAction == null) {
            LOGGER.error((Object)("Did not find any InternalAction with ID \"" + this.internalActionId + "\""));
            return;
        }
        for (InternalFailureOccurrenceDescription occurrenceDescription : internalAction.getInternalFailureOccurrenceDescriptions__InternalAction()) {
            if (!occurrenceDescription.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription().getId().equals(this.failureTypeId)) continue;
            this.description = occurrenceDescription;
            this.baseValue = occurrenceDescription.getFailureProbability();
        }
        if (this.description == null) {
            LOGGER.error((Object)("Did not find a FailureOccurrenceDescription for FailureType with ID \"" + this.failureTypeId + "\""));
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Internal Action Name");
        headings.add("Internal Action ID");
        headings.add("Failure Type Name");
        headings.add("Failure Type ID");
        headings.add("Failure Probability");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.description.getInternalAction__InternalFailureOccurrenceDescription().getEntityName());
        resultList.add(this.internalActionId);
        resultList.add(this.description.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription().getEntityName());
        resultList.add(this.failureTypeId);
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

