/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.query;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;

public class RepositoryModelLookup {
    public Repository findRepositoryById(List<Repository> repositories, String repositoryId) {
        for (Repository repository : repositories) {
            if (!repository.getId().equals(repositoryId)) continue;
            return repository;
        }
        return null;
    }

    public Repository findRepositoryByEntityName(List<Repository> repositories, String repositoryEntityName) {
        for (Repository repository : repositories) {
            if (!repository.getEntityName().equals(repositoryEntityName)) continue;
            return repository;
        }
        return null;
    }

    public RepositoryComponent findBasicComponentById(Repository repository, String basicComponentId) {
        EList components__Repository = repository.getComponents__Repository();
        Iterator iterator = components__Repository.iterator();
        if (iterator.hasNext()) {
            RepositoryComponent repositoryComponent = (RepositoryComponent)iterator.next();
            repositoryComponent.getId().equals(basicComponentId);
            return repositoryComponent;
        }
        return null;
    }

    public RepositoryComponent findBasicComponentByEntityName(Repository repository, String basicComponentEntityName) {
        EList components__Repository = repository.getComponents__Repository();
        Iterator iterator = components__Repository.iterator();
        if (iterator.hasNext()) {
            RepositoryComponent repositoryComponent = (RepositoryComponent)iterator.next();
            repositoryComponent.getEntityName().equals(basicComponentEntityName);
            return repositoryComponent;
        }
        return null;
    }

    public ServiceEffectSpecification findSeffOfComponentByOperationSignature(RepositoryComponent component, String seffOperationSignatureEntityName) {
        BasicComponent basicComponent = (BasicComponent)component;
        EList serviceEffectSpecificationsOfBasicComponent = basicComponent.getServiceEffectSpecifications__BasicComponent();
        for (ServiceEffectSpecification serviceEffectSpecification : serviceEffectSpecificationsOfBasicComponent) {
            Signature signature = serviceEffectSpecification.getDescribedService__SEFF();
            if (!signature.getEntityName().equals(seffOperationSignatureEntityName)) continue;
            return serviceEffectSpecification;
        }
        return null;
    }

    public BranchAction findSeffBranchActionById(ResourceDemandingSEFF seff, String branchActionId) {
        EList actions = seff.getSteps_Behaviour();
        for (AbstractAction action : actions) {
            BranchAction branchAction;
            if (!(action instanceof BranchAction) || !(branchAction = (BranchAction)action).getId().equals(branchActionId)) continue;
            return branchAction;
        }
        return null;
    }

    public BranchAction findSeffBranchActionByEntityName(ResourceDemandingSEFF seff, String seffEntityName) {
        EList actions = seff.getSteps_Behaviour();
        for (AbstractAction action : actions) {
            BranchAction branchAction;
            if (!(action instanceof BranchAction) || !(branchAction = (BranchAction)action).getEntityName().equals(seffEntityName)) continue;
            return branchAction;
        }
        return null;
    }

    public ProbabilisticBranchTransition findSeffProbabilisticBranchTransitionById(BranchAction branchAction, String transitionId) {
        BranchAction nextAction = branchAction;
        while (nextAction != null) {
            ProbabilisticBranchTransition probBranchTransition;
            if (nextAction instanceof StopAction) break;
            if (nextAction instanceof ProbabilisticBranchTransition && (probBranchTransition = (ProbabilisticBranchTransition)nextAction).getId().equals(transitionId)) {
                return probBranchTransition;
            }
            nextAction = nextAction.getSuccessor_AbstractAction();
        }
        return null;
    }

    public ProbabilisticBranchTransition findSeffProbabilisticBranchTransitionByEntityName(BranchAction branchAction, String transitionEntityName) {
        BranchAction nextAction = branchAction;
        EList branches_Branch = nextAction.getBranches_Branch();
        for (AbstractBranchTransition abstractBranchTransition : branches_Branch) {
            ProbabilisticBranchTransition probBranchTransition;
            if (!(abstractBranchTransition instanceof ProbabilisticBranchTransition) || !(probBranchTransition = (ProbabilisticBranchTransition)abstractBranchTransition).getEntityName().equals(transitionEntityName)) continue;
            return probBranchTransition;
        }
        return null;
    }

    public boolean isProbabilisticBranchTransitionExternalCallActionTo(ProbabilisticBranchTransition branchTransition, String operationRequiredRoleName) {
        AbstractAction nextAction = null;
        EList branchTransitionStepsBehaviour = branchTransition.getBranchBehaviour_BranchTransition().getSteps_Behaviour();
        for (AbstractAction abstractAction : branchTransitionStepsBehaviour) {
            if (!(abstractAction instanceof StartAction)) continue;
            nextAction = abstractAction;
            break;
        }
        while (nextAction != null) {
            ExternalCallAction externalCallAction;
            OperationRequiredRole roleExternalService;
            if (nextAction instanceof StopAction) break;
            if (nextAction instanceof ExternalCallAction && (roleExternalService = (externalCallAction = (ExternalCallAction)nextAction).getRole_ExternalService()).getEntityName().equals(operationRequiredRoleName)) {
                return true;
            }
            nextAction = nextAction.getSuccessor_AbstractAction();
        }
        return false;
    }
}

