/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.store.csv.accessor;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.ResourcesPlugin;

public abstract class CsvHandler {
    private static final String CSV_FILE_EXTENSION = ".csv";
    protected static final String EMPTY_STRING = "";
    protected static final String SIMULATED_EXPERIENCE_BASE_FOLDER = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/resource";
    protected static final String SAMPLE_SPACE_FILE = "SampleSpace";
    protected static final String SIMULATED_EXPERIENCE_STORE_FILE = "SimulatedExperienceStore";

    public static File loadCsvFile(String folder, String file) {
        StringBuilder builder = new StringBuilder();
        builder.append(CsvHandler.concatPathSegments(SIMULATED_EXPERIENCE_BASE_FOLDER, folder, file));
        builder.append(CSV_FILE_EXTENSION);
        return new File(builder.toString());
    }

    public static File loadOrCreate(String folder, String file) {
        File csvFolder = CsvHandler.loadOrCreateFolder(folder);
        File csvFile = new File(CsvHandler.concatPathSegments(csvFolder.getAbsolutePath(), String.valueOf(file) + CSV_FILE_EXTENSION));
        if (csvFile.exists()) {
            return csvFile;
        }
        return CsvHandler.create(csvFile);
    }

    private static File create(File csvFile) {
        try {
            csvFile.createNewFile();
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
        return csvFile;
    }

    public static File createCsvFile(String folder, String file) throws IOException {
        File csvFolder = CsvHandler.loadOrCreateFolder(folder);
        File csvFile = new File(CsvHandler.concatPathSegments(csvFolder.getAbsolutePath(), String.valueOf(file) + CSV_FILE_EXTENSION));
        if (!csvFile.exists()) {
            csvFile.createNewFile();
        }
        return csvFile;
    }

    private static File loadOrCreateFolder(String folder) {
        File csvFolder = new File(CsvHandler.concatPathSegments(SIMULATED_EXPERIENCE_BASE_FOLDER, folder));
        if (!csvFolder.exists()) {
            csvFolder.mkdirs();
        }
        return csvFolder;
    }

    protected static String constructSampleSpaceFileName(String filePrefix) {
        return String.valueOf(filePrefix) + SAMPLE_SPACE_FILE;
    }

    private static String concatPathSegments(String ... segments) {
        if (segments.length == 1) {
            return segments[0];
        }
        String[] remaining = Arrays.copyOfRange(segments, 1, segments.length);
        return CsvHandler.concatPathSegments(segments[0], CsvHandler.concatPathSegments(remaining));
    }

    private static String concatPathSegments(String first, String second) {
        return String.format("%1s/%2s", first, second);
    }

    public abstract void close();
}

